const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const cleanCSS = require('gulp-clean-css');
const path = require('path');

// Define the paths to the components and styles directories
const componentsDir = './components';
const stylesDir = './styles';
const distDir = './dist/css';

// Define a task to compile SCSS files in the "components" directory
gulp.task('sass-components', function () {
  return gulp.src(path.join(componentsDir, '**/*.scss'))
    .pipe(sass().on('error', sass.logError))
    .pipe(cleanCSS())
    .pipe(gulp.dest(function (file) {
      return file.base; // Output CSS files in the same folder as their respective SCSS files
    }));
});

// Define a task to compile SCSS files in the "styles" directory
gulp.task('sass-styles', function () {
  return gulp.src(path.join(stylesDir, '**/**/*.scss'))
    .pipe(sass().on('error', sass.logError))
    .pipe(cleanCSS())
    .pipe(gulp.dest(distDir));
});

// Define a task to watch and automatically compile SCSS files in both directories
gulp.task('watch', function () {
  gulp.watch(path.join(componentsDir, '**/*.scss'), gulp.series('sass-components'));
  gulp.watch(path.join(stylesDir, '**/**/*.scss'), gulp.series('sass-styles'));
});

// Define a default task to run both "sass-components" and "sass-styles" tasks
gulp.task('default', gulp.series('sass-components', 'sass-styles', 'watch'));
