<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xgate
 */

?>

<header class="h-fit min-h-[400px] py-10 relative items-center flex post-header">
    <section class="w-full px-6 md:px-6 lg:px-16 mx-auto max-w-5xl h-full flex flex-col justify-center text-white relative z-20">
        <div class="post-header__bubble relative max-w-fit min-w-min inline-flex items-center justify-between box-border whitespace-nowrap px-2 h-8 text-medium rounded-full text-primary-foreground mb-5 uppercase"><span class="flex-1 text-inherit font-normal px-2">Blog</span></div>
        <!-- <div class="post-header__categories relative max-w-fit min-w-min inline-flex items-center justify-between box-border whitespace-nowrap px-2 h-8 text-medium rounded-full text-primary-foreground mb-5 uppercase">
            <?php
            $categories = get_the_category();
            foreach ($categories as $category) {
            ?>

                <span class="post-header__bubble flex-1 text-inherit font-normal">
                    <a class="hover:text-white cursor-pointer flex-1 font-normal post-header__bubble-link" href="<?php echo get_category_link($category->term_id); ?>">
                        <?php echo $category->name; ?>
                    </a>
                </span>

            <?php
            }
            ?>
        </div> -->
        <h1 class="mb-5 max-w-5xl"> <?php the_title(); ?></h1>
        <div class="flex flex-col md:flex-row gap-5 justify-between">
            <div class="flex gap-3 items-center">
                <span tabindex="-1" class="flex relative justify-center items-center box-border overflow-hidden align-middle z-0 outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 w-10 h-10 text-tiny bg-primary text-primary-foreground rounded-full ring-2 ring-offset-2 ring-offset-background dark:ring-offset-background-dark ring-primary">
                    <img src="<?php echo get_avatar_url(get_the_author_meta('ID')); ?>" class="flex object-cover w-full h-full transition-opacity !duration-500 opacity-0 data-[loaded=true]:opacity-100" alt="avatar" data-loaded="true">
                </span>
                <div>
                    <p class="text-lg"><?php the_author(); ?></p>

                    <p class="text-sm"><time datetime="2024-07-12T05:25:45.000Z" title="2024-07-12T07:25:45"><?php the_date(); ?></time></p>
                </div>
            </div>
            <div class="share-button-wrapper group relative">
                <button id="share-buttons__button" class="share-buttons__button post-header__share inline-flex items-center justify-center box-border appearance-none w-full select-none whitespace-nowrap font-normal overflow-hidden tap-highlight-transparent data-[pressed=true]:scale-[0.97] outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 px-6 h-12 text-medium gap-3 [&amp;>svg]:max-w-[theme(spacing.8)] transition-transform-colors-opacity motion-reduce:transition-none data-[hover=true]:opacity-hover z-10 aria-expanded:scale-[0.97] aria-expanded:opacity-70 subpixel-antialiased text-white min-w-fit uppercase rounded-none shadow-md" type="button" data-slot="trigger" aria-haspopup="true" aria-expanded="false">Share<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="text-xl" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M383.822 344.427c-16.045 0-31.024 5.326-41.721 15.979l-152.957-88.42c1.071-5.328 2.142-9.593 2.142-14.919 0-5.328-1.071-9.593-2.142-14.919l150.826-87.35c11.762 10.653 26.741 17.041 43.852 17.041 35.295 0 64.178-28.766 64.178-63.92C448 72.767 419.117 44 383.822 44c-35.297 0-64.179 28.767-64.179 63.92 0 5.327 1.065 9.593 2.142 14.919l-150.821 87.35c-11.767-10.654-26.741-17.041-43.856-17.041-35.296 0-63.108 28.766-63.108 63.92 0 35.153 28.877 63.92 64.178 63.92 17.115 0 32.089-6.389 43.856-17.042l151.891 88.421c-1.076 4.255-2.141 8.521-2.141 13.847 0 34.094 27.806 61.787 62.037 61.787 34.229 0 62.036-27.693 62.036-61.787.001-34.094-27.805-61.787-62.035-61.787z"></path>
                    </svg>
                </button>
                <div id="share-button__socials" class="share-buttons__socials absolute gap-1 p-2">
                    <ul data-slot="list" class="w-full flex flex-col gap-0.5 outline-none" aria-label="Dynamic Actions" role="menu" tabindex="-1">
                        <li role="menuitem" tabindex="-1" data-key="$.2" class="flex group gap-2 items-center justify-between relative w-full h-full share-buttons__list-item">
                            <span id="react-aria7378748973-:r2d:" class="flex-1 text-small font-normal truncate">
                                <a class="flex items-center gap-2 text-lg h-full w-full p-1.5 share-buttons__link" target="_blank" href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path>
                                    </svg>Share on X
                                </a>
                            </span>
                        </li>
                        <li role="menuitem" tabindex="-1" data-key="$.2" class="flex group gap-2 items-center justify-between relative w-full h-full share-buttons__list-item">
                            <span id="react-aria7378748973-:r2g:" class="flex-1 text-small font-normal truncate">
                                <a class="flex items-center gap-2 text-lg h-full w-full p-1.5 share-buttons__link" target="_blank"  href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode(get_permalink()); ?>">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"></path>
                                    </svg>Share on Linkedin
                                </a>
                            </span>
                        </li>
                        <li role="menuitem" tabindex="-1" data-key="$.2" class="flex group gap-2 items-center justify-between relative w-full h-full share-buttons__list-item">
                            <span id="react-aria7378748973-:r2j:" class="flex-1 text-small font-normal truncate">
                                <a class="flex items-center gap-2 text-lg h-full w-full p-1.5 share-buttons__link" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"></path>
                                    </svg>Share on Facebook
                                </a>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <div class="h-full w-full xgate-gradient-to-r inset-0 bg-opacity-50 z-10 absolute opacity-70"></div>
    <img alt="blog" src="<?php echo the_post_thumbnail_url('full'); ?>" fetchpriority="high" decoding="async" data-nimg="fill" class="object-cover" sizes="100vw" style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;">
</header>
<section id="post-<?php the_ID(); ?>" class="max-w-5xl mx-auto">
    <section class="w-full md:px-6 lg:px-16 mx-auto max-w-screen-2xl h-full flex flex-col justify-center relative z-20 py-10">
        <div class="blog-post-content">
            <?php
            the_content(
                sprintf(
                    wp_kses(
                        /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'xgate'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    wp_kses_post(get_the_title())
                )
            );

            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'xgate'),
                    'after'  => '</div>',
                )
            );
            ?>
        </div><!-- .entry-content -->
    </section>
</section>