<?php
$title = get_the_title();
$description = get_post_meta(get_the_ID(), 'team_member_description', true);
$role = get_post_meta(get_the_ID(), 'team_member_role', true);
$formatted_role = ucwords(str_replace('_', ' ', $role));

$image1 = get_post_meta(get_the_ID(), 'team_member_image_1', true);
$image2 = get_post_meta(get_the_ID(), 'team_member_image_2', true);
$gender = get_post_meta(get_the_ID(), 'team_member_gender', true);

if ($image1) {
    $image1 = wp_get_attachment_image($image1, 'full');
} else {
    if ($gender == 'female') {
        $image1 = '<img src="' . get_template_directory_uri() . '/assets/images/female-placeholder.webp" alt="Team Female Default">';
    } else {
        $image1 = '<img src="' . get_template_directory_uri() . '/assets/images/male-placeholder.webp" alt="Team Male Default">';
    }
}

if ($image2) {
    $image2 = wp_get_attachment_image($image2, 'full');
} else {
    if ($gender == 'female') {
        $image2 = '<img src="' . get_template_directory_uri() . '/assets/images/female-placeholder.webp" alt="Team Female Default">';
    } else {
        $image2 = '<img src="' . get_template_directory_uri() . '/assets/images/male-placeholder.webp" alt="Team Male Default">';
    }
}


?>
<div class="team-mate">
    <div class="team-mate-inner">
        <div class="card-front">
            <?php echo $image1; ?>
        </div>
        <div class="card-back">
            <?php echo $image2; ?>
        </div>
    </div>
    <div class="text-center text-white p-3 bg-xgate-blue relative z-20">
        <h5 class="font-semibold"><?php echo $title; ?></h5>
        <p><?php echo $formatted_role; ?></p>
    </div>
</div>