<?php
/* Template Name: Careers */

get_header();

$query = new WP_Query(array('post_type' => 'job'));
if ($query->have_posts()) {
echo '<div class="job-listings">';
    while ($query->have_posts()) {
    $query->the_post();
    $location = get_post_meta(get_the_ID(), '_job_location', true);
    $salary = get_post_meta(get_the_ID(), '_job_salary', true);

    echo '<div class="job">';
        echo '<h2>' . get_the_title() . '</h2>';
        echo '<p>Location: ' . esc_html($location) . '</p>';
        echo '<p>Salary: ' . esc_html($salary) . '</p>';
        echo '<a href="' . get_permalink() . '">View Job</a>';
        echo '</div>';
    }
    echo '</div>';
} else {
echo 'No job listings available.';
}

wp_reset_postdata();
get_footer();