<?php
get_header(); // Include header

if (have_posts()) :
    while (have_posts()) : the_post(); ?>

        <section id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <header class="h-fit min-h-[400px] py-10 relative items-center flex post-header">
                <section class="w-full md:px-6 lg:px-16 mx-auto max-w-5xl h-full flex flex-col justify-center text-white relative z-20">
                    <div class="post-header__bubble relative max-w-fit min-w-min inline-flex items-center justify-between box-border whitespace-nowrap px-2 h-8 text-medium rounded-full text-primary-foreground mb-5 uppercase"><span class="flex-1 text-inherit font-normal px-2">Case study</span></div>
                    <h1 class="mb-5 max-w-5xl"> <?php the_title(); ?></h1>
                    <div class="flex sm:flex-col md:flex-row gap-5 justify-between">
                        <div class="flex gap-3 items-center">
                            <span tabindex="-1" class="flex relative justify-center items-center box-border overflow-hidden align-middle z-0 outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 w-10 h-10 text-tiny bg-primary text-primary-foreground rounded-full ring-2 ring-offset-2 ring-offset-background dark:ring-offset-background-dark ring-primary">
                                <img src="<?php echo get_avatar_url( get_the_author_meta( 'ID' )); ?>" class="flex object-cover w-full h-full transition-opacity !duration-500 opacity-0 data-[loaded=true]:opacity-100" alt="avatar" data-loaded="true">
                            </span>
                            <div>
                                <p class="text-lg"><?php the_author(); ?></p>
                                
                                <p class="text-sm"><time datetime="2024-07-12T05:25:45.000Z" title="2024-07-12T07:25:45"><?php the_date(); ?></time></p>
                            </div>
                        </div>
                        <button class="post-header__share group relative inline-flex items-center justify-center box-border appearance-none select-none whitespace-nowrap font-normal overflow-hidden tap-highlight-transparent data-[pressed=true]:scale-[0.97] outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 px-6 h-12 text-medium gap-3 [&amp;>svg]:max-w-[theme(spacing.8)] transition-transform-colors-opacity motion-reduce:transition-none data-[hover=true]:opacity-hover z-10 aria-expanded:scale-[0.97] aria-expanded:opacity-70 subpixel-antialiased text-white min-w-fit uppercase rounded-none shadow-md" type="button" data-slot="trigger" id="react-aria8961329714-:r1m:" aria-haspopup="true" aria-expanded="false">Share<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="text-xl" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M383.822 344.427c-16.045 0-31.024 5.326-41.721 15.979l-152.957-88.42c1.071-5.328 2.142-9.593 2.142-14.919 0-5.328-1.071-9.593-2.142-14.919l150.826-87.35c11.762 10.653 26.741 17.041 43.852 17.041 35.295 0 64.178-28.766 64.178-63.92C448 72.767 419.117 44 383.822 44c-35.297 0-64.179 28.767-64.179 63.92 0 5.327 1.065 9.593 2.142 14.919l-150.821 87.35c-11.767-10.654-26.741-17.041-43.856-17.041-35.296 0-63.108 28.766-63.108 63.92 0 35.153 28.877 63.92 64.178 63.92 17.115 0 32.089-6.389 43.856-17.042l151.891 88.421c-1.076 4.255-2.141 8.521-2.141 13.847 0 34.094 27.806 61.787 62.037 61.787 34.229 0 62.036-27.693 62.036-61.787.001-34.094-27.805-61.787-62.035-61.787z"></path>
                            </svg>
                        </button>
                    </div>
                </section>
                <div class="h-full w-full xgate-gradient-to-r inset-0 bg-opacity-50 z-10 absolute opacity-70"></div>
                <img alt="blog" src="<?php echo the_post_thumbnail_url('full'); ?>" fetchpriority="high" decoding="async" data-nimg="fill" class="object-cover" sizes="100vw" style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;">
            </header>

            <section class="max-w-5xl mx-auto">
                <section class="w-full md:px-6 lg:px-16 mx-auto max-w-screen-2xl h-full flex flex-col justify-center relative z-20 py-10">
                    <div class="blog-post-content">

                        <!-- <div class="entry-content"> -->
                        <?php
                        if (has_post_thumbnail()) {
                            // the_post_thumbnail_url('medium');
                        }
                        the_content(); // Main content of the post
                        ?>
                        <!-- </div> -->

                        <!-- <footer class="entry-footer"> -->
                        <?php
                        // Display post categories, tags, etc. if needed
                        // the_terms( $post->ID, 'case_study_category', 'Category: ', ', ' );
                        ?>
                        <!-- </footer> -->
                    </div>
                </section>
            </section>
        </section>


<?php endwhile;
endif;

get_footer(); // Include footer