jQuery(document).ready(function ($) {
    let mediaUploader, targetInput, previewImage;

    $('.team-member-image-upload').click(function (e) {
        e.preventDefault();

        targetInput = $(this).data('target');
        previewImage = $('#' + targetInput + '_preview');

        // Open the media library frame if it isn't already open
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        // Initialize media library frame
        mediaUploader = new wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }, this);

        // When an image is selected, run a callback to set its value
        mediaUploader.on('select', function () {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            debugger;
            $('input[name="' + targetInput + '"]').val(attachment.id); // Set hidden input value
            previewImage.attr('src', attachment.url); // Set preview image
        }, this);

        // Open the frame
        mediaUploader.open();
    });
});