/**
 * File navigation.js.
 *
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
(function () {
  // const siteNavigation = document.getElementById( 'site-navigation' );

  // // Return early if the navigation doesn't exist.
  // if ( ! siteNavigation ) {
  // 	return;
  // }

  // const button = siteNavigation.getElementsByTagName( 'button' )[ 0 ];

  // // Return early if the button doesn't exist.
  // if ( 'undefined' === typeof button ) {
  // 	return;
  // }

  // const menu = siteNavigation.getElementsByTagName( 'ul' )[ 0 ];

  // // Hide menu toggle button if menu is empty and return early.
  // if ( 'undefined' === typeof menu ) {
  // 	button.style.display = 'none';
  // 	return;
  // }

  // if ( ! menu.classList.contains( 'nav-menu' ) ) {
  // 	menu.classList.add( 'nav-menu' );
  // }

  // // Toggle the .toggled class and the aria-expanded value each time the button is clicked.
  // button.addEventListener( 'click', function() {
  // 	siteNavigation.classList.toggle( 'toggled' );

  // 	if ( button.getAttribute( 'aria-expanded' ) === 'true' ) {
  // 		button.setAttribute( 'aria-expanded', 'false' );
  // 	} else {
  // 		button.setAttribute( 'aria-expanded', 'true' );
  // 	}
  // } );

  // // Remove the .toggled class and set aria-expanded to false when the user clicks outside the navigation.
  // document.addEventListener( 'click', function( event ) {
  // 	const isClickInside = siteNavigation.contains( event.target );

  // 	if ( ! isClickInside ) {
  // 		siteNavigation.classList.remove( 'toggled' );
  // 		button.setAttribute( 'aria-expanded', 'false' );
  // 	}
  // } );

  // // Get all the link elements within the menu.
  // const links = menu.getElementsByTagName( 'a' );

  // // Get all the link elements with children within the menu.
  // const linksWithChildren = menu.querySelectorAll( '.menu-item-has-children > a, .page_item_has_children > a' );

  // // Toggle focus each time a menu link is focused or blurred.
  // for ( const link of links ) {
  // 	link.addEventListener( 'focus', toggleFocus, true );
  // 	link.addEventListener( 'blur', toggleFocus, true );
  // }

  // // Toggle focus each time a menu link with children receive a touch event.
  // for ( const link of linksWithChildren ) {
  // 	link.addEventListener( 'touchstart', toggleFocus, false );
  // }

  // /**
  //  * Sets or removes .focus class on an element.
  //  */
  // function toggleFocus() {
  // 	if ( event.type === 'focus' || event.type === 'blur' ) {
  // 		let self = this;
  // 		// Move up through the ancestors of the current link until we hit .nav-menu.
  // 		while ( ! self.classList.contains( 'nav-menu' ) ) {
  // 			// On li elements toggle the class .focus.
  // 			if ( 'li' === self.tagName.toLowerCase() ) {
  // 				self.classList.toggle( 'focus' );
  // 			}
  // 			self = self.parentNode;
  // 		}
  // 	}

  // 	if ( event.type === 'touchstart' ) {
  // 		const menuItem = this.parentNode;
  // 		event.preventDefault();
  // 		for ( const link of menuItem.parentNode.children ) {
  // 			if ( menuItem !== link ) {
  // 				link.classList.remove( 'focus' );
  // 			}
  // 		}
  // 		menuItem.classList.toggle( 'focus' );
  // 	}
  // }
  document.addEventListener('DOMContentLoaded', function () {
    const accordionButtons = document.querySelectorAll('button[aria-accordion-controls]');
    const accordionSections = document.querySelectorAll('.accordion-section');
    // Initialize all sections to be collapsed
    accordionButtons.forEach((button, index) => {
      const sectionId = button.getAttribute('aria-accordion-controls');
      console.log(sectionId);
      const section = accordionSections[index]; // Get the corresponding section for the button
      console.log(accordionSections);
      const parentSection = section.closest('section'); // Get the parent <section> element

      // Set dynamic IDs for button and section based on index
      const buttonId = `accordion-button-${index}`;
      const newSectionId = `accordion-section-${index}`;

      button.setAttribute('id', buttonId);
      button.setAttribute('aria-controls', newSectionId);
      accordionSections[index].setAttribute('id', newSectionId);
      accordionSections[index].setAttribute('aria-labelledby', buttonId);

      // Set initial styles for collapsed state
      parentSection.style.maxHeight = '0';
      parentSection.style.opacity = '0';
      parentSection.style.overflow = 'hidden';
      parentSection.style.transition = 'max-height 0.3s ease, opacity 0.3s ease';
      parentSection.setAttribute('data-open', 'false');
    });

    accordionButtons.forEach((button, index) => {
      const sectionId = button.getAttribute('aria-controls');
      const section = accordionSections[index]; // Get the <section> element
      const parentSection = section.closest('section'); // Get the parent <section> element

      button.addEventListener('click', function () {
        const isOpen = button.getAttribute('aria-expanded') === 'true';

        // Close all sections first
        accordionButtons.forEach((btn, idx) => {
          // Ensure we're closing the sections except the one being clicked
          if (idx !== index) {
            btn.setAttribute('aria-expanded', 'false');
            const otherSectionId = btn.getAttribute('aria-controls');
            const otherSection = document.getElementById(otherSectionId);
            const otherParentSection = otherSection.closest('section');
            otherParentSection.style.maxHeight = '0';
            otherParentSection.style.opacity = '0';
            otherParentSection.setAttribute('data-open', 'false');
          }
        });

        // Toggle the clicked button's section
        button.setAttribute('aria-expanded', !isOpen);
        parentSection.setAttribute('data-open', !isOpen);

        // Use requestAnimationFrame to ensure styles are applied correctly
        requestAnimationFrame(() => {
          if (isOpen) {
            // Collapse section
            parentSection.style.maxHeight = '0';
            parentSection.style.opacity = '0';
            parentSection.setAttribute('data-open', 'false');
          } else {
            // Expand section
            parentSection.style.maxHeight = section.scrollHeight + 'px'; // Expand to the section's full height
            parentSection.style.opacity = '1';
            parentSection.setAttribute('data-open', 'true');
          }
        });
      });
    });
  });
  const form = document.querySelector('.wpcf7-form');
  if (form) {
    form.setAttribute('autocomplete', 'off');
  }

  // Select both input and textarea fields
  const inputs = document.querySelectorAll(
    '.wpcf7-form-control-wrap input, .wpcf7-form-control-wrap textarea'
  );

  inputs.forEach((input) => {
    input.addEventListener('focus', toggleLabel);
    input.addEventListener('blur', toggleLabel);

    function toggleLabel() {
      const label = this.closest('.form-group').querySelector('.floating-label');
      if (this.value || this === document.activeElement) {
        label.classList.add('active');
      } else {
        label.classList.remove('active');
      }
    }
  });

  //social share icons
  document.addEventListener('DOMContentLoaded', function () {
    const shareButton = document.getElementById('share-buttons__button');
    const socialsMenu = document.getElementById('share-button__socials');

    if (shareButton) {
      shareButton.addEventListener('click', function () {
        const isExpanded = socialsMenu.classList.toggle('show');
        shareButton.setAttribute('aria-expanded', isExpanded);
      });

      // Close the menu if the user clicks outside of it
      document.addEventListener('click', function (event) {
        if (!shareButton.contains(event.target) && !socialsMenu.contains(event.target)) {
          socialsMenu.classList.remove('show');
          shareButton.setAttribute('aria-expanded', 'false');
        }
      });
    }
  });
})();
