<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xgate
 */

get_header();

$featured_posts = get_posts(array(
    'post_type'      => 'post',
    'posts_per_page' => 5, // Adjust to the number of featured posts you want to show
    'meta_key'       => 'is_featured',
    'meta_value'     => '1',
    'no_found_rows'  => true, // Optimizes by skipping pagination count
    'fields'         => 'ids', // Only load post IDs
));

?>

<section>
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl sm:py-10 md:py-20">
        <div class="grid md:grid-cols-1 lg:grid-cols-4 gap-8">
            <?php
            if (!empty($posts)) :
                echo '<h3 class="lg:col-span-4 mb-10">Featured blog posts</h3>';
                $index = 0;
                foreach ($featured_posts as $index => $post) :
                    // Fetch the title, excerpt, author, and categories
                    $title = get_the_title($post_id);
                    $excerpt = get_the_excerpt($post_id);
                    $author = get_the_author_meta('display_name', get_post_field('post_author', $post_id));
                    $categories = get_the_category($post_id);
                    $imageUrl =  wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                    $classes = $index == 0 ? 'blog-post md:col-span-1 lg:col-span-2 lg:row-span-2 flex flex-col shadow-xl rounded-xl bg-white' : 'blog-post col-span-1 flex flex-col lg:col-span-2 md:flex-row shadow-xl rounded-xl bg-white';

                    echo '<a class="' . $classes . '" href="' . get_the_permalink($post) . '">';

                    echo '<div class="relative min-h-[200px] w-full">';

                    echo  '<img class="bg-gray-200 object-cover md:rounded-bl-xl rounded-tl-xl rounded-tr-xl" alt="' . get_the_title() . '"  src="' . esc_url($imageUrl[0]) . '" style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;">';
                    echo '</div>';

                    echo '<div class="p-8 w-full ">';
                    echo '<p class="text-xgate-blue text-sm mb-2">' . $author . ' • ' . get_the_date('d M Y', $post_id) . '</p>';
                    echo '<h2 class="text-2xl mb-2 ">' . $title . '</h2>';
                    echo '<div class="text-gray-700 text-base mb-4 md:line-clamp-1 overflow-elipsis">';
                    echo '<p>' . $excerpt . '</p>';
                    echo '</div>';
                    if (!empty($categories)) {
                        echo '<p><strong>Categories:</strong> ';
                        foreach ($categories as $category) {
                            echo '<span>' . esc_html($category->name) . '</span> ';
                        }
                        echo '</p>';
                    }
                    echo '</div>';

                    echo '</a>';
                    $index++;

                endforeach;
            else :
                echo '<p>No featured posts found.</p>';
            endif;

            // Reset post data after custom query
            wp_reset_postdata();

            ?>
        </div>
    </section>
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 undefined">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-8 gap-y-16">
            <h3 class="md:col-span-2 lg:col-span-3">All blog posts</h3>
            <div class="md:col-span-2 lg:col-span-3">
                <div class="relative flex items-center overflow-hidden w-full">
                    <div class="flex overflow-x-auto scroll-smooth scrollbar-hide">
                        <div data-slot="base" class="inline-flex text-white" aria-label="Tabs variants">
                            <div data-slot="tabList"
                                class="flex p-1 h-fit gap-2 items-center flex-nowrap overflow-x-scroll scrollbar-hide bg-default-100 rounded-medium"
                                id="react-aria8692074531-:ra:" aria-label="Tabs variants" role="tablist"
                                aria-orientation="horizontal">
                                <?php
                                $categories = get_categories(array(
                                    'orderby' => 'name',
                                    'order'   => 'ASC'
                                ));
                                ?>
                                    <a href="/blog"
                                        class="z-0 w-full px-3 py-1 flex group relative justify-center items-center cursor-pointer transition-opacity tap-highlight-transparent data-[disabled=true]:cursor-not-allowed data-[disabled=true]:opacity-30 data-[hover-unselected=true]:opacity-disabled outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 h-8 text-small rounded-small">
                                        <div
                                            class="relative z-10 whitespace-nowrap transition-colors text-default-500 group-data-[selected=true]:text-primary-foreground">
                                            All
                                        </div>
                                    </a>
                                <?php foreach ($categories as $category) : ?>
                                    <a href="<?php echo get_category_link($category->term_id); ?>"
                                        class="z-0 w-full px-3 py-1 flex group relative justify-center items-center cursor-pointer transition-opacity tap-highlight-transparent data-[disabled=true]:cursor-not-allowed data-[disabled=true]:opacity-30 data-[hover-unselected=true]:opacity-disabled outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 h-8 text-small rounded-small">
                                        <div
                                            class="relative z-10 whitespace-nowrap transition-colors text-default-500 group-data-[selected=true]:text-primary-foreground">
                                            <?php echo esc_html($category->name); ?>
                                        </div>
                                    </a>
                                <?php endforeach; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php
            // Set posts per page and get current page
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $args = array(
                'posts_per_page' => 9,
                'paged' => $paged
            );

            // Create custom query
            $query = new WP_Query($args);

            // Start the Loop
            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
                    get_template_part('template-parts/content', 'post-list'); // Adjust 'latest-post' to your template name

                endwhile;
                wp_reset_postdata();
            else :
            ?>
                <p class="text-center text-gray-500 my-8">No posts found.</p>
            <?php
            endif;
            // Reset post data
            wp_reset_postdata();
            ?>
        </div>

        <?php
        // Pagination
        echo '<nav role="navigation" aria-label="pagination navigation" data-slot="base" data-dots-jump="5"
            data-total="4" data-active-page="1"
            class="p-2.5 -m-2.5 overflow-x-scroll scrollbar-hide mx-auto w-fit mt-16 pagination">';
        $paginate_links = paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $paged,
            'total' => $query->max_num_pages,
            'prev_text' => __('&laquo;'),
            'next_text' => __('&raquo;'),
            'type' => 'array'
        ));

        if ($paginate_links) {
            echo '<nav class="pagination" role="navigation" aria-label="Posts navigation">';
            echo '<ul class="flex flex-nowrap h-fit max-w-fit relative gap-1 items-center overflow-visible rounded-medium">';
            foreach ($paginate_links as $link) {
                // Check if link contains current class
                $is_current = strpos($link, 'current') !== false;
                $classes = $is_current
                    ? "tap-highlight-transparent select-none touch-none data-[pressed=true]:scale-[0.97] transition-transform-background flex flex-wrap truncate box-border items-center justify-center text-white outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 data-[disabled=true]:text-default-300 data-[disabled=true]:pointer-events-none shadow-sm bg-primary active:bg-primary-600 min-w-9 w-9 h-9 text-small rounded-medium"
                    : "tap-highlight-transparent select-none touch-none data-[pressed=true]:scale-[0.97] transition-transform-background flex flex-wrap truncate box-border items-center justify-center text-default-foreground outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 data-[disabled=true]:text-default-300 data-[disabled=true]:pointer-events-none shadow-sm bg-default-100 active:bg-default-300 min-w-9 w-9 h-9 text-small rounded-medium";
                echo '<li class="' . $classes . '">' . $link . '</li>';
            }
            echo '</ul>';
            echo '</nav>';
        }
        echo '</nav>';
        wp_reset_postdata();
        ?>

    </section>
</section>
<?php
// get_sidebar();
get_footer();
