<?php 
function create_service_post_type() {
    $labels = array(
        'name'               => _x('Services', 'post type general name'),
        'singular_name'      => _x('Service', 'post type singular name'),
        'menu_name'          => _x('Services', 'admin menu'),
        'name_admin_bar'     => _x('Service', 'add new on admin bar'),
        'add_new'            => _x('Add New', 'Service'),
        'add_new_item'       => __('Add New Service'),
        'new_item'           => __('New Service'),
        'edit_item'          => __('Edit Service'),
        'view_item'          => __('View Service'),
        'all_items'          => __('All Services'),
        'search_items'       => __('Search Services'),
        'not_found'          => __('No Services found.'),
        'not_found_in_trash' => __('No Services found in Trash.'),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'services'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5, // Below Posts
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt'),
        'menu_icon'          => 'dashicons-table-col-after', // Dashicon for the menu item,
        'show_in_rest'       => true,
    );

    register_post_type('service', $args);
}
add_action('init', 'create_service_post_type');

function create_service_taxonomy() {
    $labels = array(
        'name'              => _x('Service Categories', 'taxonomy general name'),
        'singular_name'     => _x('Service Category', 'taxonomy singular name'),
        'search_items'      => __('Search Service Categories'),
        'all_items'         => __('All Service Categories'),
        'parent_item'       => __('Parent Service Category'),
        'parent_item_colon' => __('Parent Service Category:'),
        'edit_item'         => __('Edit Service Category'),
        'update_item'       => __('Update Service Category'),
        'add_new_item'      => __('Add New Service Category'),
        'new_item_name'     => __('New Service Category Name'),
        'menu_name'         => __('Service Categories'),
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'services-category'),
    );

    register_taxonomy('service_category', array('service'), $args);
}
add_action('init', 'create_service_taxonomy');