<?php
class WP_Footer_Menu_Walker extends Walker_Nav_Menu {
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        // No <ul> tags needed, so this method is left empty
    }

    public function end_lvl( &$output, $depth = 0, $args = array() ) {
        // No closing </ul> tag, so this method is left empty
    }

    public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        // Output only the anchor tag for each menu item
        $output .= '<a class="footer-menu-link" href="' . esc_attr($item->url) . '">'
                    . esc_html($item->title) . '</a>';
    }

    public function end_el( &$output, $item, $depth = 0, $args = array() ) {
        // No </li> or other tags, so this method is left empty
    }
}
function register_footer_menu() {
    register_nav_menu('footer-menu', __('Footer Menu'));
}
add_action('after_setup_theme', 'register_footer_menu');