<?php

function add_featured_post_meta_box() {
    add_meta_box(
        'featured_post_meta_box',
        'Featured Post',
        'display_featured_post_meta_box',
        'post',
        'side',
        'high'
    );
}
add_action('add_meta_boxes', 'add_featured_post_meta_box');

function display_featured_post_meta_box($post) {
    $value = get_post_meta($post->ID, 'is_featured', true);
    ?>
<label>
    <input type="checkbox" name="featured_post" value="1" <?php checked($value, '1'); ?>>
    Mark as Featured Post
</label>
<?php
}

function save_featured_post_meta($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    $is_featured = isset($_POST['featured_post']) ? '1' : '';
    update_post_meta($post_id, 'is_featured', $is_featured);
}
add_action('save_post', 'save_featured_post_meta');