<?php

function customize_header_section( $wp_customize ) {
    // Rename the existing "Header Image" section to "Header"
    $wp_customize->get_section( 'header_image' )->title = __( 'Header', 'xgate' );

    // You can also add additional settings and controls here
    // For example, adding a background color to the header section
    $wp_customize->add_setting( 'header_background_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_background_color_control', array(
        'label'    => __( 'Header Background Color', 'xgate' ),
        'section'  => 'header_image',
        'settings' => 'header_background_color',
    ) ) );

    // URL Text
    $wp_customize->add_setting( 'header_url_text', array(
        'default'           => 'Contact us',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'header_url_text', array(
        'label'       => __( 'Header URL Text', 'xgate' ),
        'section'     => 'header_image',
        'type'        => 'text',
    ) );


    // URL Input
    $wp_customize->add_setting( 'header_url', array(
        'default'           => '',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ) );

    $wp_customize->add_control( 'header_url', array(
        'label'       => __( 'Header URL', 'xgate' ),
        'section'     => 'header_image',
        'type'        => 'dropdown-pages',
    ) );
}

add_action( 'customize_register', 'customize_header_section' );