<?php

function custom_theme_customize_register( $wp_customize ) {
    // Footer Section
    $wp_customize->add_section( 'footer_section', array(
        'title'       => __( 'Footer Settings', 'xgate' ),
        'priority'    => 130,
    ) );

    // Quote Input
    $wp_customize->add_setting( 'footer_quote', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'footer_quote', array(
        'label'       => __( 'Footer Quote', 'xgate' ),
        'section'     => 'footer_section',
        'type'        => 'textarea',
    ) );

    // Copyright Input
    $wp_customize->add_setting( 'footer_copyright', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'footer_copyright', array(
        'label'       => __( 'Footer Copyright Text', 'xgate' ),
		'description' => __( 'Use [year] to display the current year.', 'xgate' ),
        'section'     => 'footer_section',
        'type'        => 'text',
    ) );

	// URL Text
    $wp_customize->add_setting( 'footer_url_text', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'footer_url_text', array(
        'label'       => __( 'Footer URL Text', 'xgate' ),
        'section'     => 'footer_section',
        'type'        => 'text',
    ) );


    // URL Input
    $wp_customize->add_setting( 'footer_url', array(
        'default'           => '',
        'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
    ) );

    $wp_customize->add_control( 'footer_url', array(
        'label'       => __( 'Footer URL', 'xgate' ),
        'section'     => 'footer_section',
        'type'        => 'dropdown-pages',
    ) );

    // Social Media Section
    $wp_customize->add_section( 'social_media_section', array(
        'title'       => __( 'Social Media Settings', 'xgate' ),
        'priority'    => 135,
    ) );

    // Instagram
    $wp_customize->add_setting( 'instagram_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'instagram_url', array(
        'label'       => __( 'Instagram URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );

    // Facebook
    $wp_customize->add_setting( 'facebook_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'facebook_url', array(
        'label'       => __( 'Facebook URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );

    // LinkedIn
    $wp_customize->add_setting( 'linkedin_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'linkedin_url', array(
        'label'       => __( 'LinkedIn URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );

    // X (Twitter)
    $wp_customize->add_setting( 'x_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'x_url', array(
        'label'       => __( 'X (Twitter) URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );

    // Reddit
    $wp_customize->add_setting( 'reddit_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'reddit_url', array(
        'label'       => __( 'Reddit URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );

    // Quora
    $wp_customize->add_setting( 'quora_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'quora_url', array(
        'label'       => __( 'Quora URL', 'xgate' ),
        'section'     => 'social_media_section',
        'type'        => 'url',
    ) );
}

add_action( 'customize_register', 'custom_theme_customize_register' );