<?php

function customize_404_page( $wp_customize ) {
    // Add a new section for the 404 Page
    $wp_customize->add_section( 'custom_404_page_section', array(
        'title'       => __( '404 Page', 'xgate' ),
        'description' => __( 'Customize the 404 error page settings.', 'xgate' ),
        'priority'    => 160, // Position in the Customizer
    ) );

    // Add a setting for the 404 page custom message
    $wp_customize->add_setting( '404_title', array(
        'default'   => __( 'Oops! That page can’t be found.', 'xgate' ),
        'transport' => 'refresh', // Or 'postMessage' if using live preview with JS
    ) );

    // Add a control for the custom message
    $wp_customize->add_control( '404_title_control', array(
        'label'    => __( '404 Page Title', 'xgate' ),
        'section'  => 'custom_404_page_section',
        'settings' => '404_title',
        'type'     => 'textarea', // Textarea for longer messages
    ) );

    // Add a setting for the 404 page custom message
    $wp_customize->add_setting( '404_subtitle', array(
        'default'   => __( 'Sorry, the page you\'re looking for doesn\'t exist.', 'xgate' ),
        'transport' => 'refresh', // Or 'postMessage' if using live preview with JS
    ) );

    // Add a control for the custom message
    $wp_customize->add_control( '404_subtitle_control', array(
        'label'    => __( '404 Page Subtitle', 'xgate' ),
        'section'  => 'custom_404_page_section',
        'settings' => '404_subtitle',
        'type'     => 'textarea', // Textarea for longer messages
    ) );

}

add_action( 'customize_register', 'customize_404_page' );