<?php 
function create_case_study_post_type() {
    $labels = array(
        'name'               => _x('Case Studies', 'post type general name'),
        'singular_name'      => _x('Case Study', 'post type singular name'),
        'menu_name'          => _x('Case Studies', 'admin menu'),
        'name_admin_bar'     => _x('Case Study', 'add new on admin bar'),
        'add_new'            => _x('Add New', 'case study'),
        'add_new_item'       => __('Add New Case Study'),
        'new_item'           => __('New Case Study'),
        'edit_item'          => __('Edit Case Study'),
        'view_item'          => __('View Case Study'),
        'all_items'          => __('All Case Studies'),
        'search_items'       => __('Search Case Studies'),
        'not_found'          => __('No case studies found.'),
        'not_found_in_trash' => __('No case studies found in Trash.'),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'case-study'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5, // Below Posts
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt'),
        'menu_icon'          => 'dashicons-portfolio', // Dashicon for the menu item,
        'show_in_rest'       => true,
    );

    register_post_type('case_study', $args);
}
add_action('init', 'create_case_study_post_type');

function create_case_study_taxonomy() {
    $labels = array(
        'name'              => _x('Case Study Categories', 'taxonomy general name'),
        'singular_name'     => _x('Case Study Category', 'taxonomy singular name'),
        'search_items'      => __('Search Case Study Categories'),
        'all_items'         => __('All Case Study Categories'),
        'parent_item'       => __('Parent Case Study Category'),
        'parent_item_colon' => __('Parent Case Study Category:'),
        'edit_item'         => __('Edit Case Study Category'),
        'update_item'       => __('Update Case Study Category'),
        'add_new_item'      => __('Add New Case Study Category'),
        'new_item_name'     => __('New Case Study Category Name'),
        'menu_name'         => __('Case Study Categories'),
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'case-study-category'),
    );

    register_taxonomy('case_study_category', array('case_study'), $args);
}
add_action('init', 'create_case_study_taxonomy');


//add customize options 
function case_study_customizer_settings($wp_customize) {
    // Add a section for the Case Study page
    $wp_customize->add_section('case_study_section', array(
        'title'       => __('Case Study Page', 'xgate'),
        'description' => __('Customize the Case Study Page', 'xgate'),
        'priority'    => 30,
    ));

    // Add setting for the title
    $wp_customize->add_setting('case_study_title', array(
        'default'   => 'Default Case Study Title',
        'transport' => 'refresh',
    ));

    // Add control for the title
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'case_study_title_control', array(
        'label'    => __('Case Study Title', 'xgate'),
        'section'  => 'case_study_section',
        'settings' => 'case_study_title',
        'type'     => 'text',
    )));

    // Add setting for the description
    $wp_customize->add_setting('case_study_description', array(
        'default'   => 'This is a default description for the Case Study page.',
        'transport' => 'refresh',
    ));

    // Add control for the description
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'case_study_description_control', array(
        'label'    => __('Case Study Description', 'xgate'),
        'section'  => 'case_study_section',
        'settings' => 'case_study_description',
        'type'     => 'textarea',
    )));
}
add_action('customize_register', 'case_study_customizer_settings');