const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;


registerBlockType('xgate/text-faq', {
    title: __('Text FAQ', 'xgate'),
    icon: 'smiley',
    category: 'xgate-blocks',
    attributes: {
        question: {
            type: 'string',
        },
        answer: {
            type: 'string',
        
        },
    },
    edit: function (props) {
        const { attributes, setAttributes, className } = props;
        const { question, answer, content } = attributes;

        return (
            <div className='text-faq'>
            <InnerBlocks
              allowedBlocks={['xgate/content-cta', 'xgate/faq']}
              template={[
                ['xgate/content-cta', {}],
                ['xgate/faq', {}]
              ]}
              templateLock={false}
            />
          </div>
        );
    },
    save: props => <InnerBlocks.Content/>
});