<?php

/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_text_faq_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-text-faq-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/text-faq/build/text-faq.js', // Block.build.js: We register the block here. Built with Webpack.
        array('wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-text-faq-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/text-faq',
        array(
            'editor_script' => 'xgate-text-faq-js',
            'render_callback' => 'text_faq_render'
        )
    );
}

function text_faq_render($attributes, $content)
{
    $question = isset($attributes['question']) ? $attributes['question'] : '';
    $answer = isset($attributes['answer']) ? $attributes['answer'] : '';

    ob_start();
?>
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 faq-text">
        <div class="flex gap-12 flex-col md:flex-row">
            <?php echo $content ?>
        </div>
    </section>
<?php
    return ob_get_clean();
}


// Hook: Block assets.
add_action('init', 'xgate_text_faq_assets');
