<?php
/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_service_list_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-service-list-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/service-list/build/service-list.js', // Block.build.js: We register the block here. Built with Webpack.
        array( 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-service-list-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/service-list', array(
            'editor_script' => 'xgate-service-list-js',
            'render_callback' => 'my_service_list_render',
            'provides_context' => [ 'xgate/service-list-variant' ],
        )
    );
}

function my_service_list_render( $attributes, $content ) {
    $title = isset( $attributes['title'] ) ? $attributes['title'] : '';
    ob_start();
    ?>

<section>
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 undefined">
        <div class="opacity-0 "
            style="translate: none; rotate: none; scale: none; transform: translate(0px, 0px); opacity: 1;">
            <h2 class="mb-9  max-w-4xl mx-auto text-center">We are the secret weapon that empowers you to achieve your
                most ambitious goals.</h2>
        </div>
        <div style="translate: none; rotate: none; scale: none; transform: translate(0px, 0px); opacity: 1;">
            <div class="grid sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
                <?php echo $content ?>
            </div>
        </div>
    </section>
</section>

<?php
        return ob_get_clean();
    }
    

// Hook: Block assets.
add_action('init', 'xgate_service_list_assets');