const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;
const { Fragment } = wp.element;
import IconSelector from '../icon-selector/icon-selector.js'; // Import the reusable component

registerBlockType('xgate/service-list-item', {
  title: __('Service list item', 'xgate'),
  icon: 'smiley',
  category: 'xgate-blocks',
  attributes: {
    title: {
      type: 'string',
    },
    subtitle: {
      type: 'string',
    },
    content: {
      type: 'string',
    },
    selectedIcon: {
      type: 'string',
      default: '',
    },
  },
  parent: ['xgate/service-list'],
  usesContext: ['xgate/service-list-variant'],

  edit: function (props) {
    const { attributes, setAttributes, className, context } = props;
    const { title, subtitle, content, imageUrl, variant, selectedIcon } = attributes;

    const onTitleChange = (value) => {
      setAttributes({ title: value });
    };

    const onSubtitleChange = (value) => {
      setAttributes({ subtitle: value });
    };

    const onContentChange = (value) => {
      setAttributes({ content: value });
    };

    const onSelectImage = (media) => {
      setAttributes({
        imageUrl: media.url,
        imageId: media.id,
      });
    };

    const onVariantChange = (value) => {
      setAttributes({ variant: value });
    };

    // Function to handle icon selection
    const handleIconSelect = (icon) => {
      setAttributes({ selectedIcon: icon });
    };

    return (
      <div className={className}>
        <Fragment>
          <IconSelector
            selectedIcon={selectedIcon}
            onIconSelect={handleIconSelect}
          />

          <div className='icon-preview'>
            {selectedIcon && (
              <img
                src={`${mythemeIconBlockData.iconPath}${selectedIcon}`}
                alt={selectedIcon}
                height="45"
                width="45"
              />
            )}
          </div>
        </Fragment>
        {/* <InspectorControls>
                    <PanelBody title={__('Block Settings', 'xgate')}>
                        <SelectControl
                            label={__('Content Variant', 'xgate')}
                            value={variant}
                            options={[
                                { label: __('Center Content', 'xgate'), value: 'content-center' },
                                { label: __('Half Width Content', 'xgate'), value: 'content-half' },
                                { label: __('30% / 70% Split', 'xgate'), value: 'content-30' },
                                { label: __('70% / 30% Split', 'xgate'), value: 'content-70' },
                            ]}
                            onChange={onVariantChange}
                        />
                    </PanelBody>
                </InspectorControls> */}

        <RichText
          tagName='h3'
          placeholder={__('Add Title', 'xgate')}
          value={title}
          onChange={onTitleChange}
        />
        <RichText
          tagName='h4'
          placeholder={__('Add Subtitle', 'xgate')}
          value={subtitle}
          onChange={onSubtitleChange}
        />
        <RichText
          tagName='p'
          placeholder={__('Add content', 'xgate')}
          value={content}
          onChange={onContentChange}
        />
        <MediaUpload
          onSelect={onSelectImage}
          allowedTypes={['image']}
          value={props.attributes.imageId}
          render={({ open }) => (
            <Button
              className='button button-large'
              onClick={open}>
              {!imageUrl ? (
                __('Choose an image', 'xgate')
              ) : (
                <img
                  src={imageUrl}
                  width='50'
                  heigh='50'
                  alt={__('Selected Image', 'xgate')}
                />
              )}
            </Button>
          )}
        />
        {/* <InnerBlocks allowedBlocks={['*']} /> */}
      </div>
    );
  },
  save: function () {
    return null; // Dynamic rendering with PHP
  },
});
