<?php
/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_service_list_item_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-service-list-item-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/service-list-item/build/service-list-item.js', // Block.build.js: We register the block here. Built with Webpack.
        array( 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

       // Get the list of SVG icons from the theme folder

   

    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-service-list-item-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

     // Localize the SVG list to use in the block editor
     wp_localize_script( 'xgate-service-list-item-js', 'mythemeIconBlockData', array(
        'iconPath' => get_template_directory_uri() . '/assets/icons/',
    ));

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/service-list-item', array(
            'editor_script' => 'xgate-service-list-item-js',
            'render_callback' => 'my_service_list_item_render',
            'uses_context' => [ 'xgate/service-list-variant' ],
        )
    );
}

function my_service_list_item_render( $attributes, $content, $block ) {
    $title = isset( $attributes['title'] ) ? $attributes['title'] : '';
    $subtitle = isset( $attributes['subtitle'] ) ? $attributes['subtitle'] : '';
    $contentText = isset( $attributes['content'] ) ? $attributes['content'] : '';
    $imageUrl = isset( $attributes['imageUrl'] ) ? $attributes['imageUrl'] : '';
    $variant = isset( $attributes['variant'] ) ? $attributes['variant'] : 'content-center';
    $selectedIcon = isset( $attributes['selectedIcon'] ) ? $attributes['selectedIcon'] : '';
    
    // Add variant class to the block container
    // $variant_class = 'my-custom-block ' . esc_attr( $variant );

    
    ob_start();
    ?>


<div class="relative group  block p-2 h-full w-full service-list-item">
    <div class="h-full w-full p-4 overflow-hidden bg-white rounded-xl relative z-20 shadow-2xl">
        <div class="relative z-50">
            <div class="p-4">
                <?php if ( !empty( $selectedIcon ) ) : ?>
                <img height="64" width="64" style="margin-bottom: 1.25rem;" src="<?php echo get_template_directory_uri() . '/assets/icons/' . $selectedIcon; ?> "
                    alt="selectedIcon" />
                <?php endif; ?>
                <h3 class="text-black h4-styles"><?php echo $title?></h3>
                <p class="mt-5 text-gray-500 leading-relaxed"><?php echo $contentText ?></p>
            </div>
        </div>
    </div>
</div>
<?php
        return ob_get_clean();
    }
    

// Hook: Block assets.
add_action('init', 'xgate_service_list_item_assets');