const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, InspectorControls } = wp.blockEditor;
const { Button, PanelBody, SelectControl, TextControl } = wp.components;


registerBlockType('xgate/quote', {
    title: __('Quote', 'xgate'),
    icon: 'format-quote', 
    category: 'xgate-blocks',
    attributes: {
        quote: {
            type: 'string',
        },
        author: {
            type: 'string',
        
        },
    },
    edit: function (props) {
        const { attributes, setAttributes } = props;
        const { quote, author } = attributes;

        const onQuoteChange = (value) => {
            setAttributes({ quote: value });
        };

        const onAuthorChange = (value) => {
            setAttributes({ author: value });
        };
      

        return (
            <div >
                <RichText
                    tagName="p"
                    placeholder={__('Add Quote', 'xgate')}
                    value={quote}
                    onChange={onQuoteChange}
                />
                 <TextControl
                    value={ author }
                    onChange={onAuthorChange}
                />
            </div>
        );
    },
    save: function () {
        return null; // Dynamic rendering with PHP
    },
});