const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;


registerBlockType('xgate/my-custom-block', {
    title: __('My Custom Block', 'xgate'),
    icon: 'smiley',
    category: 'xgate-blocks',
    attributes: {
        title: {
            type: 'string',
        },
        subtitle: {
            type: 'string',
        
        },
        content: {
            type: 'string',
        },
        imageUrl: {
            type: 'string',
        },
        imageId: {
            type: 'number',
        },
        variant: {
            type: 'string',
            default: 'content-center',
        },
    },
    edit: function (props) {
        const { attributes, setAttributes, className } = props;
        const { title, subtitle, content, imageUrl, variant } = attributes;

        const onTitleChange = (value) => {
            setAttributes({ title: value });
        };

        const onSubtitleChange = (value) => {
            setAttributes({ subtitle: value });
        };

        const onContentChange = (value) => {
            setAttributes({ content: value });
        };

        const onSelectImage = (media) => {
            setAttributes({
                imageUrl: media.url,
                imageId: media.id
            });
        };

        const onVariantChange = (value) => {
            setAttributes({ variant: value });
        };

        return (
            <div className={className}>
                <InspectorControls>
                    <PanelBody title={__('Block Settings', 'xgate')}>
                        <SelectControl
                            label={__('Content Variant', 'xgate')}
                            value={variant}
                            options={[
                                { label: __('Center Content', 'xgate'), value: 'content-center' },
                                { label: __('Half Width Content', 'xgate'), value: 'content-half' },
                                { label: __('30% / 70% Split', 'xgate'), value: 'content-30' },
                                { label: __('70% / 30% Split', 'xgate'), value: 'content-70' },
                            ]}
                            onChange={onVariantChange}
                        />
                    </PanelBody>
                </InspectorControls>
                
                <RichText
                    tagName="h1"
                    placeholder={__('Add Title', 'xgate')}
                    value={title}
                    onChange={onTitleChange}
                />
                <RichText
                    tagName="h2"
                    placeholder={__('Add Subtitle', 'xgate')}
                    value={subtitle}
                    onChange={onSubtitleChange}
                />
                <RichText
                    tagName="p"
                    placeholder={__('Add content', 'xgate')}
                    value={content}
                    onChange={onContentChange}
                />
                <MediaUpload
                    onSelect={onSelectImage}
                    allowedTypes={['image']}
                    value={props.attributes.imageId}
                    render={({ open }) => (
                        <Button className="button button-large" onClick={open}>
                            {!imageUrl ? __('Choose an image', 'xgate') : (
                                <img src={imageUrl} width="50" heigh="50" alt={__('Selected Image', 'xgate')} />
                            )}
                        </Button>
                    )}
                />
                {/* <InnerBlocks allowedBlocks={['*']} /> */}
            </div>
        );
    },
    save: function () {
        return null; // Dynamic rendering with PHP
    },
});