const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, InspectorControls } = wp.blockEditor;
const { Button, PanelBody, SelectControl, TextControl } = wp.components;


registerBlockType('xgate/latest-posts', {
    title: __('Latest Posts', 'xgate'),
    icon: 'excerpt-view',
    category: 'xgate-blocks',
    attributes: {
        numberOfPosts: {
            type: 'number',
            default: 3,
        },
    },
    edit: function (props) {
        const { attributes, setAttributes } = props;
        const { numberOfPosts } = attributes;

        const onNumberOfPostsChange = (value) => {
            setAttributes({ numberOfPosts: value });
        };

        return (
            <div >
                <h1>Latest Posts</h1>
                <TextControl
                    value={numberOfPosts}
                    onChange={onNumberOfPostsChange}
                />
            </div>
        );
    },
    save: function () {
        return null; // Dynamic rendering with PHP
    },
});