const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;

registerBlockType('xgate/image-text', {
  title: __('Image Text', 'xgate'),
  icon: 'cover-image',
  category: 'xgate-blocks',
  attributes: {
    title: {
      type: 'string',
    },
    subtitle: {
      type: 'string',
    },
    content: {
      type: 'string',
    },
    imageUrl: {
      type: 'string',
    },
    imageId: {
      type: 'number',
    },
    variant: {
      type: 'string',
      default: 'content-center',
    },
    design: {
      type: 'string',
      default: 'transparent',
    },
  },
  edit: function (props) {
    const { attributes, setAttributes, className } = props;
    const { variant, design } = attributes;

    const onDesignChange = (value) => {
      setAttributes({ design: value });
    };

    const onVariantChange = (value) => {
      setAttributes({ variant: value });
    };

    return (
      <div className={className}>
        <h2>Image & Text Block</h2>
        <InspectorControls>
          <PanelBody title={__('Block Settings', 'xgate')}>
            <SelectControl
              label={__('Content Variant', 'xgate')}
              value={variant}
              options={[
                { label: __('Image Text', 'xgate'), value: 'image-text' },
                { label: __('Text Image', 'xgate'), value: 'text-image' },
              ]}
              onChange={onVariantChange}
            />
            <SelectControl
              label={__('Design Variant', 'xgate')}
              value={design}
              options={[
                { label: __('Dark', 'xgate'), value: 'dark' },
                { label: __('Transparent', 'xgate'), value: 'transparent' },
              ]}
              onChange={onDesignChange}
            />
          </PanelBody>
        </InspectorControls>

        <div className='text-image flex flex-row gap-4'>
          <InnerBlocks
            allowedBlocks={['xgate/content-cta', 'xgate/image-block']}
            template={[
              ['xgate/content-cta', {}],
              ['xgate/image-block', {}]
            ]}
            templateLock={false}
          />
        </div>
      </div>
    );
  },
  save: (props) => <InnerBlocks.Content />,
});
