const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;

registerBlockType('xgate/image-block', {
  title: __('Image Block', 'xgate'),
  icon: 'format-image',
  category: 'xgate-blocks',
  attributes: {
    title: {
      type: 'string',
    },
    imageUrl: {
      type: 'string',
    },
    imageId: {
      type: 'number',
    },
    design: {
      type: 'string',
    },
    imageSize: {
      type: 'string'
    }
  },
  edit: function (props) {
    const { attributes, setAttributes, className } = props;
    const { imageUrl, design, imageSize } = attributes;

    const onSelectImage = (media) => {
      setAttributes({
        imageUrl: media.url,
        imageId: media.id,
      });
    };

    const onDesignChange = (value) => {
      setAttributes({ design: value });
    };
    const onImageSizeChange = (value) => {
      setAttributes({ imageSize: value });
    };

    return (
      <div className={className}>
        <h3>Add Image</h3>
        <div className='flex sm:flex-col md:flex-row gap-6'>
          <SelectControl
            label={__('Image Size', 'xgate')}
            value={imageSize}
            options={[
              { label: __('Auto height', 'xgate'), value: 'auto-height' },
              { label: __('Height 400', 'xgate'), value: 'height-400' },
              { label: __('Height 300', 'xgate'), value: 'height-300' },
              { label: __('Height 200', 'xgate'), value: 'height-200' },
            ]}
            onChange={onImageSizeChange}
          />
          <SelectControl
            label={__('Content Variant', 'xgate')}
            value={design}
            options={[
              { label: __('with Effect', 'xgate'), value: 'with-effect' },
              { label: __('No Effect', 'xgate'), value: 'no-effect' },
            ]}
            onChange={onDesignChange}
          />
        </div>

        <MediaUpload
          onSelect={onSelectImage}
          allowedTypes={['image']}
          value={props.attributes.imageId}
          render={({ open }) => (
            <Button
              className={`button button-large w-auto h-auto ${design}`}
              onClick={open}>
              {!imageUrl ? (
                __('Choose an image', 'xgate')
              ) : (
                <img
                  src={imageUrl}
                  width='150'
                  heigh='150'
                  alt={__('Selected Image', 'xgate')}
                />
              )}
            </Button>
          )}
        />
        {/* <InnerBlocks allowedBlocks={['*']} /> */}
      </div>
    );
  },
  save: function () {
    return null; // Dynamic rendering with PHP
  },
});
