<?php
/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

function mytheme_get_icon_list() {
    $icon_dir = get_template_directory() . '/assets/svg/'; // Adjust path if necessary
    $icons = [];

    if (is_dir($icon_dir)) {
        $files = scandir($icon_dir);
        foreach ($files as $file) {
            if (preg_match('/\.(svg|png|jpg|jpeg)$/', $file)) { // Adjust extensions as needed
                $icons[] = get_template_directory_uri() . '/assets/svg/' . $file;
            }
        }
    }

    return $icons;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_icon_selector_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-icon-selector-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/icon-selector/build/icon-selector.js', // Block.build.js: We register the block here. Built with Webpack.
        array( 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

       // Get the list of SVG icons from the theme folder
       $icon_dir = get_template_directory() . '/assets/icons/';
       $icons = array_diff( scandir( $icon_dir ), array( '..', '.' ) );
       $svg_icons = array();
   
       foreach ( $icons as $icon ) {
           if ( pathinfo( $icon, PATHINFO_EXTENSION ) === 'svg' || pathinfo( $icon, PATHINFO_EXTENSION ) === 'webp' ) {
               $svg_icons[] = $icon;
           }
       }
   

    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-icon-selector-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

     // Localize the SVG list to use in the block editor
     wp_localize_script( 'xgate-icon-selector-js', 'iconsData', array(
        'icons' => $svg_icons,
        'iconPath' => get_template_directory_uri() . '/assets/icons/',
    ));

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/icon-selector', array(
            'editor_script' => 'xgate-icon-selector-js',
        )
    );
}


// Hook: Block assets.
add_action('init', 'xgate_icon_selector_assets');