const IconSelector = ({ selectedIcon, onIconSelect }) => {
    const icons = iconsData.icons; // Get icons from localized data
    const iconPath = iconsData.iconPath; // Get icons from localized data

    const handleIconSelect = (icon) => {
        onIconSelect(icon);
    };

        const blockStyles = `
            .icon-selector {
                display: flex;
                flex-wrap: wrap;
                gap: 12px;
            }
            .icon-label {
                cursor: pointer;
                display: inline-block;
                transition: transform 0.2s ease;
            }
            .icon-label:hover {
                transform: scale(1.1);
            }
            .icon-option {
                width: 50px;
                height: 50px;
                border-radius: 4px;
                transition: border-color 0.2s ease;
            }
            .icon-radio:checked + img {
                border: 2px solid #007cba;
                border-radius: 4px;
            }
            .icon-selected {
                border-color: #007cba;
            }
        `;

    return (
        <div className="icon-selector">
            <style>{blockStyles}</style>
            {icons.map((icon, index) => (
                <label key={index} className="icon-label">
                    <input
                        type="radio"
                        name="selectedIcon"
                        value={iconPath + icon}
                        className="icon-radio"
                        checked={selectedIcon === icon}
                        onChange={() => handleIconSelect(icon)}
                        style={{ display: 'none' }} // Hidden radio button
                    />
                    <img
                        src={iconPath + icon}
                        alt={`Icon ${index + 1}`}
                        className={`icon-option ${selectedIcon === icon ? 'icon-selected' : ''}`}
                        onClick={() => handleIconSelect(icon)}
                        height="50"
                        width="50"
                    />
                </label>
            ))}
        </div>
    );
};

export default IconSelector;