const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;

registerBlockType('xgate/faq', {
  title: __('FAQ', 'xgate'),
  icon: 'smiley',
  category: 'xgate-blocks',
  attributes: {
    content: {
      type: 'string',
    },
    sectionTitle: {
      type: 'string',
    },
  },
  edit: function (props) {
    const { attributes, setAttributes, className } = props;
    const { content, sectionTitle } = attributes;

    const onSectionTitleChange = (value) => {
      setAttributes({ sectionTitle: value });
    };

    return (
      <div className={className}>
        <h1>FAQ Block</h1>
        <RichText
          tagName='h2'
          placeholder={__('Section title (optional)', 'xgate')}
          value={sectionTitle}
          onChange={onSectionTitleChange}
        />
        <InnerBlocks
          allowedBlocks={['xgate/faq-item']}
          templateLock={false}
        />
      </div>
    );
  },
  save: (props) => <InnerBlocks.Content />,
});
