<?php

/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_faq_item_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-faq-item-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/faq-item/build/faq-item.js', // Block.build.js: We register the block here. Built with Webpack.
        array('wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-faq-item-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/faq-item',
        array(
            'editor_script' => 'xgate-faq-item-js',
            'render_callback' => 'faq_item_render'
        )
    );
}

function faq_item_render($attributes, $content)
{
    $question = isset($attributes['question']) ? $attributes['question'] : '';
    $answer = isset($attributes['answer']) ? $attributes['answer'] : '';

    ob_start();
?>
    <div class="w-full font-light text-lg" aria-label="Inspire & Empower" data-open="false">
        <h2>
            <button class="flex py-4 w-full h-full gap-3 items-center" type="button" id="accordion-button-0" aria-expanded="false" data-open="false" aria-controls="accordion-section-0" aria-accordion-controls="accordion-section-0">
                <div class="flex-1 flex flex-col text-start">
                    <span class="text-foreground text-xl">
                        <p class="font-normal text-xl"><span class="mr-5"><?php echo $question ?></span></p>
                    </span>
                </div>
                <span aria-hidden="true" class="text-xgate-blue text-4xl faq-chevron">
                    <svg aria-hidden="true" fill="none" viewBox="0 0 24 24" width="1em" class="faq-icon">
                        <path d="M15.5 19l-7-7 7-7" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"></path>
                    </svg>
                </span>
            </button>
        </h2>
        <section style="opacity: 0; max-height: 0; overflow: hidden;" class="accordion-answer">
            <div data-open="false" class="py-2 accordion-section" id="accordion-section-0" role="region" aria-labelledby="accordion-button-0">
                <div class="xgate-list-styles"><?php echo $answer ?></div>
            </div>
        </section>
        <hr class="shrink-0 bg-divider border-none w-full h-divider" role="separator">
    </div>
<?php
    return ob_get_clean();
}


// Hook: Block assets.
add_action('init', 'xgate_faq_item_assets');
