const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;


registerBlockType('xgate/faq-item', {
    title: __('Faq item', 'xgate'),
    icon: 'smiley',
    category: 'xgate-blocks',
    attributes: {
        question: {
            type: 'string',
        },
        answer: {
            type: 'string',
        
        },
    },
    edit: function (props) {
        const { attributes, setAttributes, className } = props;
        const { question, answer, content } = attributes;

        const onQuestionChange = (value) => {
            setAttributes({ question: value });
        };

        const onAnswerChange = (value) => {
            setAttributes({ answer: value });
        };

        return (
            <div className={className}>
                <h1>Question - Answer</h1>
                <RichText
                    tagName="h1"
                    placeholder={__('Add Question', 'xgate')}
                    value={question}
                    onChange={onQuestionChange}
                />
                <RichText
                    tagName="h2"
                    placeholder={__('Add Answer', 'xgate')}
                    value={answer}
                    onChange={onAnswerChange}
                />
                {/* <InnerBlocks allowedBlocks={['*']} /> */}
            </div>
        );
    },
    save: function () {
        return null; // Dynamic rendering with PHP
    },
});