const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;

registerBlockType('xgate/expanded-service-list', {
  title: __('Expanded service List', 'xgate'),
  icon: 'excerpt-view', // Block icon from Dashicons → https://developer.wordpress.org/resource/dashicons/.
  category: 'xgate-blocks',
  attributes: {
    variant: {
      type: 'string',
      default: 'services',
    },
  },

  providesContext: {
    'xgate/service-list-variant': 'variant',
  },
  edit: function (props) {
    const { attributes, setAttributes } = props;
    const { variant } = attributes;

    const onVariantChange = (value) => {
      setAttributes({ variant: value });
    };
    return (
      <div style={{ border: '1px solid black', padding: '10px' }}>
        <h1>Service item Container </h1>
        <InspectorControls>
          <PanelBody title={__('Block Settings', 'xgate')}>
            <SelectControl
              label={__('Content Variant', 'xgate')}
              value={variant}
              options={[
                { label: __('', 'xgate'), value: '' },
                { label: __('Services', 'xgate'), value: 'services' },
                { label: __('Assets', 'xgate'), value: 'assets' },
              ]}
              onChange={onVariantChange}
            />
          </PanelBody>
        </InspectorControls>
        <InnerBlocks allowedBlocks={['xgate/expanded-service-list-item']} />
      </div>
    );
  },
  save: (props) => <InnerBlocks.Content />,
});
