<?php

/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package xgate
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 2. blocks.build.js - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function xgate_expanded_service_list_item_assets()
{ // phpcs:ignore

    // Register block editor script for backend.
    wp_register_script(
        'xgate-expanded-service-list-item-js', // Handle.
        get_template_directory_uri() . '/inc/blocks/expanded-service-list-item/build/expanded-service-list-item.js', // Block.build.js: We register the block here. Built with Webpack.
        array('wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components'), // Dependencies, defined above.
        null, // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: filemtime — Gets file modification time.
        true // Enqueue the script in the footer.
    );

    // Get the list of SVG icons from the theme folder



    // WP Localized globals. Use dynamic PHP stuff in JavaScript via `cgbGlobal` object.
    wp_localize_script(
        'xgate-expanded-service-list-item-js',
        'cgbGlobal', // Array containing dynamic data for a JS Global.
        [
            'pluginDirPath' => plugin_dir_path(__DIR__),
            'pluginDirUrl' => plugin_dir_url(__DIR__),
        ]
    );

    // Localize the SVG list to use in the block editor
    wp_localize_script('xgate-expanded-service-list-item-js', 'mythemeIconBlockData', array(
        'iconPath' => get_template_directory_uri() . '/assets/icons/',
    ));

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type(
        'xgate/expanded-service-list-item',
        array(
            'editor_script' => 'xgate-expanded-service-list-item-js',
            'render_callback' => 'my_expanded_service_list_item_render',
            'uses_context' => ['xgate/expanded-service-list-variant'],
        )
    );
}

function my_expanded_service_list_item_render($attributes, $content, $block)
{
    $title = isset($attributes['title']) ? $attributes['title'] : '';
    $contentText = isset($attributes['content']) ? $attributes['content'] : '';
    $selectedIcon = isset($attributes['selectedIcon']) ? $attributes['selectedIcon'] : '';

    ob_start();
?>
    <li class="bg-white px-6 py-8 shadow-sm border-1 border-xgate-dark-blue border-b-8 text-center">
        <?php if (!empty($selectedIcon)) : ?>
            <img alt="service-image" loading="lazy" width="70" height="70" decoding="async" data-nimg="1" class="mx-auto mb-8" src="<?php echo get_template_directory_uri() . '/assets/icons/' . $selectedIcon; ?> " style="color: transparent;">
        <?php endif; ?>
        <h2 class="my-5 font-medium h5-styles"><?php echo $title ?></h2>
        <p class="mt-1.5 text-md leading-6 text-gray-500 "><?php echo $contentText ?></p>
    </li>
<?php
    return ob_get_clean();
}


// Hook: Block assets.
add_action('init', 'xgate_expanded_service_list_item_assets');
