const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText } = wp.blockEditor;
const { Fragment } = wp.element;
import IconSelector from '../icon-selector/icon-selector.js'; // Import the reusable component


registerBlockType('xgate/expanded-service-list-item', {
    title: __('Expanded service list item', 'xgate'),
    icon: 'smiley',
    category: 'xgate-blocks',
    attributes: {
        title: {
            type: 'string',
        },
        content: {
            type: 'string',
        },
        selectedIcon: {
            type: 'string',
            default: ''
        }
    },
    parent: ['xgate/expanded-service-list'],
    usesContext: ['xgate/expanded-service-list-variant'],

    edit: function (props) {
        const { attributes, setAttributes, className, context } = props;
        const { title, content, selectedIcon } = attributes;

        const onTitleChange = (value) => {
            setAttributes({ title: value });
        };

        const onContentChange = (value) => {
            setAttributes({ content: value });
        };



         // Function to handle icon selection
         const handleIconSelect = (icon) => {
            setAttributes({ selectedIcon: icon });
        };

        return (
            <div className={className}>
                  <Fragment>
                  <IconSelector
                    selectedIcon={selectedIcon}
                    onIconSelect={handleIconSelect}
                    />
                <div className="icon-preview">
                    {selectedIcon && (
                        <img src={`${mythemeIconBlockData.iconPath}${selectedIcon}`} alt={selectedIcon} />
                    )}
                </div>
            </Fragment>

                <RichText
                    tagName="h2"
                    placeholder={__('Add Title', 'xgate')}
                    value={title}
                    onChange={onTitleChange}
                />
                <RichText
                    tagName="p"
                    placeholder={__('Add content', 'xgate')}
                    value={content}
                    onChange={onContentChange}
                />
            </div>
        );
    },
    save: function () {
        return null; // Dynamic rendering with PHP
    },
});