const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { RichText, MediaUpload, InspectorControls, InnerBlocks, URLInputButton } = wp.blockEditor;
const { Button, PanelBody, SelectControl } = wp.components;

registerBlockType('xgate/content-cta', {
  title: __('Content cta', 'xgate'),
  icon: 'plugins-checked',
  category: 'xgate-blocks',
  attributes: {
    title: {
      type: 'string',
    },
    subtitle: {
      type: 'string',
    },
    textContent: {
      type: 'string',
    },
    variant: {
      type: 'string',
      default: 'primary',
    },
    design: {
      type: 'string',
      default: 'white-blue',
    },
    url: {
      type: 'string',
      default: '/homepage',
    },
    text: {
      type: 'string',
      default: 'Contact us',
    },
    buttonText: {
      type: 'string',
      default: 'Click me',
    },
  },
  edit: function (props) {
    const { attributes, setAttributes, className } = props;
    const { title, subtitle, variant, textContent, buttonText, content } = attributes;

    const onTitleChange = (value) => {
      setAttributes({ title: value });
    };

    const onSubtitleChange = (value) => {
      setAttributes({ subtitle: value });
    };

    const onTextContentChange = (value) => {
      setAttributes({ textContent: value });
    };

    const onVariantChange = (value) => {
      setAttributes({ variant: value });
    };

    const onChangeButtonText = (value) => {
      setAttributes({ buttonText: value });
    };

    return (
      <div className={className}>
        <h3>Content CTA</h3>
        <RichText
          tagName='h2'
          placeholder={__('Add Title', 'xgate')}
          value={title}
          onChange={onTitleChange}
        />
        <RichText
          tagName='h3'
          placeholder={__('Add Subtitle', 'xgate')}
          value={subtitle}
          onChange={onSubtitleChange}
        />
        <RichText
          tagName='p'
          placeholder={__('Add text', 'xgate')}
          value={textContent}
          onChange={onTextContentChange}
        />
        <SelectControl
          label={__('Button Variant', 'xgate')}
          value={variant}
          options={[
            { label: __('Primary', 'xgate'), value: 'primary' },
            { label: __('Secondary', 'xgate'), value: 'secondary' },
          ]}
          onChange={onVariantChange}
        />
        <RichText
          tagName='p'
          placeholder={__('Add Button Text', 'xgate')}
          onChange={onChangeButtonText}
        />
        <URLInputButton
          variant={attributes.variant}
          url={attributes.url}
          onChange={(url, post) =>
            setAttributes({
              url,
              text: buttonText || post.title,
              variant: attributes.variant,
            })
          }
        />

        {/* <InnerBlocks allowedBlocks={['*']} /> */}
      </div>
    );
  },
  save: function () {
    return null; // Dynamic rendering with PHP
  },
});
