<?php
/**
 * Plugin Name: Blocks Library
 * Plugin URI:
 * Description: Blocks Library — is a Gutenberg plugin library with guten blocks
 * Author: Aleksandar Kostadinovski
 * Author URI: https://kostadinovski.info
 * Version: 1.0.0
 * License: GPL2+
 * L    icense URI: https://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package BL
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

function xgate_blocks($categories, $post)
{
	return array_merge(
		$categories,
		array(
			array(
				'slug' => 'xgate-blocks',
				'title' => __('Xgate blocks', 'xgate-blocks'),
			),
		)
	);
}

add_filter('block_categories', 'xgate_blocks', 10, 2);

/**
 * Block Initializer.
 */
require_once(get_template_directory() . '/inc/blocks/icon-selector/init.php');
require_once(get_template_directory() . '/inc/blocks/my-custom-block/init.php');
require_once(get_template_directory() . '/inc/blocks/xgate-stage/init.php');
require_once(get_template_directory() . '/inc/blocks/service-list/init.php');
require_once(get_template_directory() . '/inc/blocks/service-list-item/init.php');
require_once(get_template_directory() . '/inc/blocks/content-cta/init.php');
require_once(get_template_directory() . '/inc/blocks/solo-cta/init.php');
require_once(get_template_directory() . '/inc/blocks/image-block/init.php');
require_once(get_template_directory() . '/inc/blocks/image-text/init.php');
require_once(get_template_directory() . '/inc/blocks/quote/init.php');
require_once(get_template_directory() . '/inc/blocks/faq-item/init.php');
require_once(get_template_directory() . '/inc/blocks/faq/init.php');
require_once(get_template_directory() . '/inc/blocks/gallery/init.php');
require_once(get_template_directory() . '/inc/blocks/latest-posts/init.php');
require_once(get_template_directory() . '/inc/blocks/text-faq/init.php');
require_once(get_template_directory() . '/inc/blocks/expanded-service-list/init.php');
require_once(get_template_directory() . '/inc/blocks/expanded-service-list-item/init.php');