<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package xgate
 */
$custom_logo_id = get_theme_mod('custom_logo');
$image = wp_get_attachment_image_src($custom_logo_id, 'full');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <link rel="stylesheet" href="<?php echo  get_template_directory_uri() . '/assets/main.css' ?>" />
    <link rel="stylesheet" href="<?php echo  get_template_directory_uri() . '/assets/second.css' ?>" />

    <link rel="icon" href="<?php echo  get_template_directory_uri() . '/assets/images/favicon.ico' ?>" type="image/x-icon"
        sizes="256x256">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> class="__variable_3dbca6 __variable_d940b1 font-nunito relative min-h-screen bg-gray-50"
    id="main-container">
    <?php wp_body_open(); ?>
    <div>
        <nav class="main-navigation flex w-full h-auto items-center justify-center data-[menu-open=true]:border-none sticky top-0 inset-x-0 data-[menu-open=true]:backdrop-blur-xl backdrop-saturate-150 transition-none filter-none backdrop-saturate-[none] bg-black backdrop-blur-none z-[1999] shadow-md"
            style="--navbar-height: 4rem;">
            <div id="menu-overlay" class="menu-overlay"></div>
            <header
                class="header z-40 flex px-6 gap-4 w-full flex-row relative flex-nowrap items-center justify-between h-[var(--navbar-height)] 2xl:max-w-[90vw] max-w-full">
                <div
                    class="flex basis-0 flex-row flex-grow flex-nowrap justify-start bg-transparent items-center no-underline text-medium whitespace-nowrap box-border">
                    <a href="/"><img alt="xgate-logo" loading="lazy" width="100" height="40" decoding="async"
                            data-nimg="1" src="<?php echo $image[0]; ?>" style=" color: transparent;"></a>
                </div>
                <?php wp_nav_menu(array(
                    'theme_location' => 'mega-menu',
                    'walker' => new WP_Mega_Menu_Walker(), // Use the custom walker from the previous step
                    'container' => 'ul',
                    'menu_class' => 'main-menu flex-row flex-nowrap items-center data-[justify=start]:justify-start data-[justify=start]:flex-grow data-[justify=start]:basis-0 data-[justify=center]:justify-center data-[justify=end]:justify-end data-[justify=end]:flex-grow data-[justify=end]:basis-0 whitespace-nowrap lg:hidden xl:flex gap-7 !justify-center',
                    'items_wrap' => '<ul id="%1$s" class="%2$s" data-justify="start">%3$s</ul>', // Adds the "data-justify" attribute
                ));

                wp_reset_postdata();
                ?>

                <!-- <ul class="hamburger flex gap-4 h-full flex-row flex-nowrap items-center data-[justify=start]:justify-start data-[justify=start]:flex-grow data-[justify=start]:basis-0 data-[justify=center]:justify-center data-[justify=end]:justify-end data-[justify=end]:flex-grow data-[justify=end]:basis-0"
                    data-justify="end">
                    <li
                        class="text-medium whitespace-nowrap box-border list-none data-[active=true]:font-semibold relative h-full items-center data-[active=true]:after:content-[''] data-[active=true]:after:absolute data-[active=true]:after:z-[999] data-[active=true]:after:bottom-0 data-[active=true]:after:left-0 data-[active=true]:after:right-0 data-[active=true]:after:h-[2px] data-[active=true]:after:rounded-[2px] data-[active=true]:after:bg-primary hidden xl:flex">
                        <a class="z-0 group relative inline-flex items-center justify-center box-border appearance-none select-none whitespace-nowrap subpixel-antialiased overflow-hidden tap-highlight-transparent data-[pressed=true]:scale-[0.97] outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 px-4 min-w-20 h-10 text-small gap-2 [&amp;>svg]:max-w-[theme(spacing.8)] transition-transform-colors-opacity motion-reduce:transition-none bg-primary data-[hover=true]:opacity-hover uppercase rounded-full tracking-wider text-white font-normal"
                            role="button" tabindex="0" href="<?php echo get_permalink(get_theme_mod('header_url')); ?>">
                            <div class="relative w-2 h-2">
                                <div class="absolute inset-0 rounded-full bg-xgate-blue-300 animate-ping"></div>
                                <div class="relative w-full h-full rounded-full bg-xgate-blue-300"></div>
                            </div>
                            <?php echo get_theme_mod('header_url_text'); ?>
                        </a>
                    </li>
                    <button
                        class="hamburger-button group flex items-center justify-center w-6 h-full rounded-small tap-highlight-transparent outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 xl:hidden text-white"
                        type="button" aria-pressed="false"><span class="sr-only">open navigation menu</span><span
                            class="w-full h-full pointer-events-none flex flex-col items-center justify-center text-inherit group-data-[pressed=true]:opacity-70 transition-opacity before:content-[''] before:block before:h-px before:w-6 before:bg-current before:transition-transform before:duration-150 before:-translate-y-1 before:rotate-0 group-data-[open=true]:before:translate-y-px group-data-[open=true]:before:rotate-45 after:content-[''] after:block after:h-px after:w-6 after:bg-current after:transition-transform after:duration-150 after:translate-y-1 after:rotate-0 group-data-[open=true]:after:translate-y-0 group-data-[open=true]:after:-rotate-45"></span>
                        </button>
                </ul> -->
                <ul class="hamburger flex gap-4 h-full flex-row flex-nowrap items-center data-[justify=start]:justify-start data-[justify=start]:flex-grow data-[justify=start]:basis-0 data-[justify=center]:justify-center data-[justify=end]:justify-end data-[justify=end]:flex-grow data-[justify=end]:basis-0" data-justify="end">
                    <!-- 'Contact Us' button for desktop -->
                    <li class="text-medium whitespace-nowrap box-border list-none hidden xl:flex">
                        <a class="z-0 group relative inline-flex items-center justify-center box-border appearance-none select-none whitespace-nowrap subpixel-antialiased overflow-hidden tap-highlight-transparent data-[pressed=true]:scale-[0.97] outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 px-4 min-w-20 h-10 text-small gap-2 [&amp;>svg]:max-w-[theme(spacing.8)] transition-transform-colors-opacity motion-reduce:transition-none bg-primary data-[hover=true]:opacity-hover uppercase rounded-full tracking-wider text-white font-normal" role="button" tabindex="0" href="https://xgate.io/contact-us/">
                            <div class="relative w-2 h-2">
                                <div class="absolute inset-0 rounded-full bg-xgate-blue-300 animate-ping"></div>
                                <div class="relative w-full h-full rounded-full bg-xgate-blue-300"></div>
                            </div>
                            Contact us
                        </a>
                    </li>

                    <!-- Hamburger button for mobile -->
                    <button class="hamburger-button group flex items-center justify-center w-6 h-full rounded-small tap-highlight-transparent outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 xl:hidden text-white" type="button" aria-pressed="false">
                        <span class="sr-only">open navigation menu</span>
                        <span class="w-full h-full pointer-events-none flex flex-col items-center justify-center text-inherit group-data-[pressed=true]:opacity-70 transition-opacity before:content-[''] before:block before:h-px before:w-6 before:bg-current before:transition-transform before:duration-150 before:-translate-y-1 before:rotate-0 group-data-[open=true]:before:translate-y-px group-data-[open=true]:before:rotate-45 after:content-[''] after:block after:h-px after:w-6 after:bg-current after:transition-transform after:duration-150 after:translate-y-1 after:rotate-0 group-data-[open=true]:after:translate-y-0 group-data-[open=true]:after:-rotate-45"></span>
                    </button>
                </ul>
                <div class="w-full fixed left-0 top-[64px] bg-black z-[9999] transition-height duration-400 ease-in-out overflow-hidden hidden xl:block"
                    style="height: 0px;">
                    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl undefined flex h-full">
                        <ul class="text-white py-10">
                            <li class="w-[350px] group"><a
                                    class="p-5 flex gap-10 items-center uppercase group-hover:bg-gray-900 group-hover:text-xgate-blue"
                                    href="/services"><span
                                        class="group-hover:translate-x-2 transition">Overview</span></a></li>
                            <li class="w-[350px]"><a class="p-5 flex justify-between gap-8 items-center "
                                    href="/services/cloud-services-and-it-infrastructure"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Cloud services and
                                        IT infrastructure</span><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li class="w-[350px]"><a class="p-5 flex justify-between gap-8 items-center "
                                    href="/services/staff-augmentation"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Staff
                                        augmentation</span><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li class="w-[350px]"><a class="p-5 flex justify-between gap-8 items-center "
                                    href="/services/digital-product-development"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Digital Product
                                        Development</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li class="w-[350px]"><a class="p-5 flex justify-between gap-8 items-center "
                                    href="/services/digital-marketing"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Digital
                                        Marketing</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                        </ul>
                    </section>
                </div>
                <div
                    class="h-0 opacity-0 w-full fixed left-0 top-[64px] bg-black bg-opacity-60 delay-75 transition-opacity duration-400 ease-in-out overflow-hidden">
                </div>
                <div class="w-full fixed left-0 top-[64px] hidden xl:block invisible pointer-events-none">
                    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl undefined flex h-full">
                        <ul class="text-white py-10">
                            <li><a class="p-5 flex gap-10 items-center "
                                    href="/services/cloud-services-and-it-infrastructure"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Cloud services and
                                        IT infrastructure</span><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li><a class="p-5 flex gap-10 items-center " href="/services/staff-augmentation"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Staff
                                        augmentation</span><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li><a class="p-5 flex gap-10 items-center "
                                    href="/services/digital-product-development"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Digital Product
                                        Development</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                            <li><a class="p-5 flex gap-10 items-center " href="/services/digital-marketing"><span
                                        class=" transition-all group-hover:text-xgate-blue uppercase">Digital
                                        Marketing</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right transition duration-300  w-5">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg><span
                                        class="hidden transition duration-300 group-hover:inline w-5 text-center text-xl">-</span></a>
                            </li>
                        </ul>
                    </section>
                </div>
            </header>
        </nav>
