<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package xgate
 */
$custom_logo_id = get_theme_mod('custom_logo');
$image = wp_get_attachment_image_src($custom_logo_id, 'full');
?>
</div>

<footer class="pt-12 md:pt-24 pb-8 bg-xgate-dark-blue mt-auto text-white relative">
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl undefined relative z-10">
        <p class="text-3xl md:text-5xl leading-[2.5rem] md:leading-[4rem] mb-5">
            <?php echo esc_html(get_theme_mod('footer_quote')); ?></p>
        <div class="md:text-right flex justify-end w-full gap-5 flex-col md:flex-row md:items-center">
            <p><?php
                // Retrieve the copyright text from the customizer
                $copyright_text = get_theme_mod('footer_copyright');

                // Replace the [year] placeholder with the current year
                $copyright_text = str_replace('[year]', date('Y'), $copyright_text);

                echo esc_html($copyright_text);
                ?></p><a
                href="<?php echo get_permalink(get_theme_mod('footer_url')); ?>"><?php echo esc_html(get_theme_mod('footer_url_text')); ?></a>
        </div>
        <hr class="border-white my-8">
        <div class="flex justify-between flex-wrap gap-5">
            <div class="flex gap-7 items-end flex-wrap">

                <img alt="" loading="lazy" width="100" height="50" decoding="async" data-nimg="1"
                    src="<?php echo $image[0]; ?>" style="color: transparent;">
                <?php wp_nav_menu(array(
                    'theme_location' => 'footer-menu', // Register this menu location if not already done
                    'walker' => new WP_Footer_Menu_Walker(), // Use the custom walker for the footer
                    'container' => false, // No <div> or <nav> container
                    'items_wrap' => '%3$s', // Skip wrapping the links in <ul> or <ol>
                    'echo' => true,
                    'depth' => 1, // Limit to top-level links if needed
                ));
                ?>
                <!-- <a href="/services">Services</a><a
                    href="/technologies">Technologies</a><a href="/case-studies">Case studies</a><a
                    href="/about-us">About us</a><a href="/blog">Blog</a><a href="/team">Team</a><a
                    href="/careers">Careers</a><a href="/contact">Contact us</a> -->
            </div>
            <div class="flex gap-5">
                <?php if (get_theme_mod('instagram_url')) : ?>
                    <a aria-label="Visit X Gate Instagram" href="<?php echo esc_url(get_theme_mod('instagram_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if (get_theme_mod('facebook_url')) : ?>
                    <a aria-label="Visit X Gate Facebook" href="<?php echo esc_url(get_theme_mod('facebook_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if (get_theme_mod('linkedin_url')) : ?>
                    <a aria-label="Visit X Gate LinkedIn" href="<?php echo esc_url(get_theme_mod('linkedin_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if (get_theme_mod('x_url')) : ?>
                    <a aria-label="Visit X Gate X" href="<?php echo esc_url(get_theme_mod('x_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm297.1 84L257.3 234.6 379.4 396H283.8L209 298.1 123.3 396H75.8l111-126.9L69.7 116h98l67.7 89.5L313.6 116h47.5zM323.3 367.6L153.4 142.9H125.1L296.9 367.6h26.3z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if (get_theme_mod('reddit_url')) : ?>
                    <a aria-label="Visit X Gate Reddit" href="<?php echo esc_url(get_theme_mod('reddit_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if (get_theme_mod('quora_url')) : ?>
                    <a aria-label="Visit X Gate Quora" href="<?php echo esc_url(get_theme_mod('quora_url')); ?>"
                        target="_blank">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512"
                            class="hover:text-xgate-blue cursor-pointer" height="30" width="30"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M440.5 386.7h-29.3c-1.5 13.5-10.5 30.8-33 30.8-20.5 0-35.3-14.2-49.5-35.8 44.2-34.2 74.7-87.5 74.7-153C403.5 111.2 306.8 32 205 32 105.3 32 7.3 111.7 7.3 228.7c0 134.1 131.3 221.6 249 189C276 451.3 302 480 351.5 480c81.8 0 90.8-75.3 89-93.3zM297 329.2C277.5 300 253.3 277 205.5 277c-30.5 0-54.3 10-69 22.8l12.2 24.3c6.2-3 13-4 19.8-4 35.5 0 53.7 30.8 69.2 61.3-10 3-20.7 4.2-32.7 4.2-75 0-107.5-53-107.5-156.7C97.5 124.5 130 71 205 71c76.2 0 108.7 53.5 108.7 157.7.1 41.8-5.4 75.6-16.7 100.5z">
                            </path>
                        </svg>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </section><img alt="xgate-pattern" loading="lazy" decoding="async" data-nimg="fill" class="object-cover"
        src="<?php echo get_template_directory_uri(); ?>/assets/images/brand-pattern-01.svg" alt="Xgate brand pattern"
        style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;">
</footer>

<?php wp_footer(); ?>

</body>

</html>