<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package xgate
 */

get_header();
?>

<section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 undefined">
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-8 gap-y-16">
        <h3 class="md:col-span-2 lg:col-span-3"><?php the_archive_title(); ?></h3>
        <div class="md:col-span-2 lg:col-span-3">
            <div class="relative flex items-center overflow-hidden w-full">
                <div class="flex overflow-x-auto scroll-smooth scrollbar-hide">
                    <div data-slot="base" class="inline-flex text-white" aria-label="Tabs variants">
                        <div data-slot="tabList"
                            class="flex p-1 h-fit gap-2 items-center flex-nowrap overflow-x-scroll scrollbar-hide bg-default-100 rounded-medium"
                            id="react-aria8692074531-:ra:" aria-label="Tabs variants" role="tablist"
                            aria-orientation="horizontal">
                            <a href="/blog"
                                class="z-0 w-full px-3 py-1 flex group relative justify-center items-center cursor-pointer transition-opacity tap-highlight-transparent data-[disabled=true]:cursor-not-allowed data-[disabled=true]:opacity-30 data-[hover-unselected=true]:opacity-disabled outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 h-8 text-small rounded-small">
                                        <div
                                            class="relative z-10 whitespace-nowrap transition-colors text-default-500 group-data-[selected=true]:text-primary-foreground">
                                            All
                                        </div>
                                    </a>
                            <?php
                            $categories = get_categories(array(
                                'orderby' => 'name',
                                'order'   => 'ASC'
                            ));
                            
                            foreach ($categories as $category) : ?>
                            <?php
                            // Get current category if we're on a category archive page
                            $current_cat = get_queried_object();
                            $current_cat_id = $current_cat instanceof WP_Term ? $current_cat->term_id : 0;
                            
                            // Add border class if this category matches current category
                            $border_class = ($current_cat_id === $category->term_id) ? 'text-white' : '';
                            ?>
                            <a href="<?php echo $current_cat_id === $category->term_id ? '#' : get_category_link($category->term_id); ?>"
                                class=" z-0 w-full px-3 py-1 flex group relative justify-center items-center cursor-pointer transition-opacity tap-highlight-transparent data-[disabled=true]:cursor-not-allowed data-[disabled=true]:opacity-30 data-[hover-unselected=true]:opacity-disabled outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 h-8 text-small rounded-small">
                                <?php if ($current_cat_id === $category->term_id) : ?>
                                <span
                                    class="absolute z-0 inset-0 rounded-small bg-primary text-primary-foreground"></span>

                                <?php endif; ?>
                                <div
                                    class="<?php echo $border_class; ?> relative z-10 whitespace-nowrap transition-colors text-default-500 group-data-[selected=true]:text-primary-foreground">
                                    <?php echo esc_html($category->name); ?>
                                </div>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php
            if (have_posts()) :
                while (have_posts()) : the_post();
                    ?>
        <a class="blog-post flex flex-col shadow-xl rounded-xl bg-white" href="<?php the_permalink(); ?>">
            <div class="relative min-h-[200px] w-full">
                <img alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy" decoding="async" data-nimg="fill"
                    class="bg-gray-200 object-cover rounded-tl-xl rounded-tr-xl" sizes="100vw"
                    src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'medium_large'); ?>"
                    style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;">
            </div>
            <div class="p-8 w-full ">
                <p class="text-xgate-blue text-sm mb-2"><?php echo get_the_author(); ?> •
                    <?php echo get_the_date(); ?></p>
                <h2 class="text-2xl mb-2 "><?php the_title(); ?></h2>
                <div class="text-gray-700 text-base mb-4 ">
                    <?php the_excerpt(); ?>
                </div>
                <div class="flex gap-2">
                    <?php
                                $categories = get_the_category();
                                if ($categories) :
                                    foreach ($categories as $category) :
                                        ?>
                    <div
                        class="relative max-w-fit min-w-min inline-flex items-center justify-between box-border whitespace-nowrap px-1 h-7 text-small rounded-full bg-primary text-white">
                        <span
                            class="flex-1 text-inherit font-normal px-2"><?php echo esc_html($category->name); ?></span>
                    </div>
                    <?php
                                    endforeach;
                                endif;
                                ?>
                </div>
            </div>

        </a>
        <?php
                endwhile;

                echo '<nav role="navigation" aria-label="pagination navigation" data-slot="base" data-dots-jump="5"
                    data-total="4" data-active-page="1"
                    class="p-2.5 -m-2.5 overflow-x-scroll scrollbar-hide mx-auto w-fit mt-16 pagination">';
                
                $paginate_links = paginate_links(array(
                    'prev_text' => __('&laquo;'),
                    'next_text' => __('&raquo;'),
                    'type' => 'array'
                ));

                if ($paginate_links) {
                    echo '<nav class="pagination" role="navigation" aria-label="Posts navigation">';
                    echo '<ul class="flex flex-nowrap h-fit max-w-fit relative gap-1 items-center overflow-visible rounded-medium">';
                    foreach ($paginate_links as $link) {
                        $is_current = strpos($link, 'current') !== false;
                        $classes = $is_current 
                            ? "tap-highlight-transparent select-none touch-none data-[pressed=true]:scale-[0.97] transition-transform-background flex flex-wrap truncate box-border items-center justify-center text-white outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 data-[disabled=true]:text-default-300 data-[disabled=true]:pointer-events-none shadow-sm bg-primary active:bg-primary-600 min-w-9 w-9 h-9 text-small rounded-medium"
                            : "tap-highlight-transparent select-none touch-none data-[pressed=true]:scale-[0.97] transition-transform-background flex flex-wrap truncate box-border items-center justify-center text-default-foreground outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 data-[disabled=true]:text-default-300 data-[disabled=true]:pointer-events-none shadow-sm bg-default-100 active:bg-default-300 min-w-9 w-9 h-9 text-small rounded-medium";
                        echo '<li class="' . $classes . '">' . $link . '</li>';
                    }
                    echo '</ul>';
                    echo '</nav>';
                }
                echo '</nav>';

            else :
                ?>
        <p class="text-center text-gray-500 my-8"><?php esc_html_e('No posts found.', 'xgate'); ?></p>
        <?php
            endif;
            wp_reset_postdata(); 
            ?>
    </div>
    </div>
</section>

<?php
get_footer();