<?php get_header(); ?>
<section class="w-full overflow-hidden relative flex items-center background-xgate-digital-pattern bg-gray-50"
    style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/background-xgate-digital-pattern.svg');">
    <section
        class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 flex flex-col lg:flex-row gap-x-24 gap-y-12  items-center justify-between">
        <div>
            <h1 class="text-black mb-7 h1-big-styles font-medium">
                <?php echo get_theme_mod('team_title', 'Meet Our Team'); ?></h1>
            <hr class="border-b-8 border-xgate-blue mb-5">
            <p class="text-xl lg:text-2xl tracking-wide font-light max-w-2xl text-black">
                <?php echo get_theme_mod('team_description', 'Our team is a diverse group of
                skilled professionals, each bringing their own expertise and creativity to the table. Together, we are
                dedicated to driving success and innovation in every project, ensuring the best outcomes for our
                clients.'); ?>
            </p>
        </div>
    </section>
</section>
<section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl">
    <section
        class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4  gap-x-5 gap-y-10 py-5 justify-center px-5">
        <?php
    $args = [
        'post_type' => 'team',
        'orderby' => 'menu_order',
        'order' => 'ASC',
        'posts_per_page' => -1,
    ];
    $team_query = new WP_Query($args);
    if ($team_query->have_posts()) :
        while ($team_query->have_posts()) : $team_query->the_post();
            get_template_part('template-parts/content', 'team');
        endwhile;
        wp_reset_postdata();
    else :
        echo '<p>No team members found</p>';
    endif;
        ?>
    </section>
</section>
<?php get_footer(); ?>