<?php
get_header(); // Include header ?>
<div>
    <section class="w-full overflow-hidden relative flex items-center background-xgate-digital-pattern bg-gray-50"
        style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/background-xgate-digital-pattern.svg');">
        <section
            class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 flex flex-col lg:flex-row gap-x-24 gap-y-12  items-center justify-between">
            <div>
                <h1 class="text-black mb-7 h1-big-styles font-medium">
                    <?php echo get_theme_mod('case_study_title', 'Case studies'); ?></h1>
                <hr class="border-b-8 border-xgate-blue mb-5">
                <p class="text-xl lg:text-2xl tracking-wide font-light max-w-2xl text-black">
                    <?php echo get_theme_mod('case_study_description', 'Explore how we\'ve helped clients achieve their goals and learn from real-world examples of our work.'); ?>
                </p>
            </div>
        </section>
    </section>
    <section class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20">
        <div class="grid lg:grid-cols-3 md:grid-cols-2 gap-10">

            <?php if ( have_posts() ) : ?>

            <?php
            // Loop through the case studies
            while ( have_posts() ) : the_post(); ?>
            <?php get_template_part('template-parts/content', 'case_study'); ?>

            <?php endwhile; ?>


            <?php the_posts_navigation(); // Pagination ?>
            <?php else : ?>
            <p>No case studies found.</p>
            <?php endif; ?>

        </div>
    </section>
</div>
<?php
get_footer(); // Include footer