<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package xgate
 */

get_header();
?>

<section
    class="w-full px-6 lg:px-16 mx-auto max-w-screen-2xl py-10 sm:py-20 h-[calc(100vh-463px)] min-h-fit flex flex-col items-center justify-center">
    <h1 class="lg:text-7xl font-bold text-xgate-blue">404</h1>
    <h2 class="lg:text-3xl font-semibold mt-4 text-center">
        <?php echo esc_html( get_theme_mod('404_title'), __('Oops! That page can’t be found.', 'xgate') ); ?></h2>
    <p class="mt-2 text-gray-500 text-center">
        <?php echo esc_html( get_theme_mod('404_subtitle'), __('Sorry, the page you\'re looking for doesn\'t exist.', 'xgate') ); ?>
    </p><a
        class="z-0 group relative inline-flex items-center justify-center box-border appearance-none select-none whitespace-nowrap font-normal subpixel-antialiased overflow-hidden tap-highlight-transparent data-[pressed=true]:scale-[0.97] outline-none data-[focus-visible=true]:z-10 data-[focus-visible=true]:outline-2 data-[focus-visible=true]:outline-focus data-[focus-visible=true]:outline-offset-2 px-6 min-w-24 h-12 text-medium gap-3 [&amp;>svg]:max-w-[theme(spacing.8)] transition-transform-colors-opacity motion-reduce:transition-none bg-primary data-[hover=true]:opacity-hover uppercase rounded-full tracking-wider text-white mt-6"
        role="button" tabindex="0" href="/">Go Back Home</a>
</section>

<?php
get_footer();