"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjectTransform = void 0;
const EnteredArgs_1 = require("./EnteredArgs");
const EndedArgs_1 = require("./EndedArgs");
const stream_1 = require("stream");
class ObjectTransform extends stream_1.Transform {
    constructor(args) {
        super({ objectMode: true });
        args = args || {};
        this.enteredAsync = this.createEnteredAsync(args);
        this.endedAsync = this.createEndedAsync(args);
        this.onSourceStreamError = this.createOnSourceStreamError(args);
        this.listenToSourceStreamErrors();
    }
    _transform(chunk, encoding, callback) {
        this.enteredAsync(new EnteredArgs_1.EnteredAsyncArgs(chunk, this, callback));
    }
    _flush(callback) {
        this.endedAsync(new EndedArgs_1.EndedAsyncArgs(this, callback));
    }
    createOnSourceStreamError(args) {
        return args.onSourceStreamError ||
            ((e) => { e.emitError(e.error); });
    }
    listenToSourceStreamErrors() {
        let errorListener = (error) => {
            let args = {
                error: error,
                emitError: (error) => { this.emit("error", error); }
            };
            try {
                this.onSourceStreamError(args);
            }
            catch (error) {
                this.emit("error", error);
            }
        };
        this.on("pipe", src => {
            src.on("error", errorListener);
        });
        this.on("unpipe", src => {
            src.removeListener("error", errorListener);
        });
    }
    createEnteredAsync(params) {
        if (params.onEntered && params.onEnteredAsync) {
            throw new Error("only one of the 'entered' methods can be asigned.");
        }
        return params.onEnteredAsync ||
            (params.onEntered && this.getOnEnteredAsAsync(params.onEntered)) ||
            this.passThroughAsync;
    }
    createEndedAsync(params) {
        if (params.onEnded && params.onEndedAsync) {
            throw new Error("only one of the 'all processed' methods can be asigned.");
        }
        if (params.onEnded) {
            return this.getOnEndedAsAsync(params.onEnded);
        }
        else {
            return params.onEndedAsync || this.finishAsync;
        }
    }
    getOnEnteredAsAsync(onEntered) {
        return (args) => {
            try {
                const result = onEntered(args);
                if (!(result === null || result === void 0 ? void 0 : result.then)) {
                    args.done();
                    return;
                }
                result.then(() => { args.done(); }, e => { args.failed(e); });
            }
            catch (error) {
                args.failed(error);
            }
        };
    }
    getOnEndedAsAsync(onEnded) {
        return (args) => {
            try {
                onEnded(args);
                args.done();
            }
            catch (error) {
                args.failed(error);
            }
        };
    }
    passThroughAsync(args) {
        args.output.push(args.object);
        args.done();
    }
    finishAsync(args) {
        args.done();
    }
}
exports.ObjectTransform = ObjectTransform;
