const accordionItems = document.querySelectorAll('.accordion-item');
const accordionContainer = document.querySelector('.custom-accordion');

accordionItems.forEach(item => {
  const button = item.querySelector('.accordion-button');

  // Listen for the collapse event
  button.addEventListener('click', () => {
    // Remove 'open' class from all accordion items
    accordionItems.forEach(i => i.classList.remove('opened'));

    // If the current item is open, add 'open' class
    if (button.classList.contains('collapsed')) {
      item.classList.remove('opened');
    } else {
      item.classList.add('opened');
    }
  });
});