/**
 * @file
 * Global utilities.
 *
 */
(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.bootstrap = {
    attach: function (context, settings) {
      var position = $(window).scrollTop();
      $(window).scroll(function () {
        if ($(this).scrollTop() > 50) {
          $('body').addClass('scrolled');
        } else {
          $('body').removeClass('scrolled');
        }
        var scroll = $(window).scrollTop();
        if (scroll > position) {
          $('body').addClass('scrolldown');
          $('body').removeClass('scrollup');
        } else {
          $('body').addClass('scrollup');
          $('body').removeClass('scrolldown');
        }
        position = scroll;
      });

      $('.dropdown-item a.dropdown-toggle').on('click', function (e) {
        $(this).next('ul').toggle();
        e.stopPropagation();
        e.preventDefault();
      });
    },
  };
})(jQuery, Drupal);
