<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* dna:carousel */
class __TwigTemplate_67e5bd0682e39f775271d57e039ce565 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\ui_patterns\Template\TwigExtension']->normalizeProps($context, "dna:carousel"));
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\Core\Template\TwigExtension']->attachLibrary("core/components.dna--carousel"));
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\Core\Template\ComponentsTwigExtension']->addAdditionalContext($context, "dna:carousel"));
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\Core\Template\ComponentsTwigExtension']->validateProps($context, "dna:carousel"));
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\ui_patterns\Template\TwigExtension']->preprocessProps($context, "dna:carousel"));
        yield " <div class=\"carousel_wrapper container\">
  ";
        // line 2
        if ( !Twig\Extension\CoreExtension::testEmpty(($context["eyebrow"] ?? null))) {
            // line 3
            yield "    <span class=\"carousel_wrapper__eyebrow mb-3\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["eyebrow"] ?? null), "html", null, true);
            yield "</span>
  ";
        }
        // line 5
        yield "
  ";
        // line 6
        if ( !Twig\Extension\CoreExtension::testEmpty(($context["title"] ?? null))) {
            // line 7
            yield "    <h2 class=\"carousel_wrapper__title mb-5\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title"] ?? null), "html", null, true);
            yield "</h2>
  ";
        }
        // line 9
        yield "
  <div id=\"myCarousel\" class=\"carousel slide\">
    <!-- Slides -->
    <div class=\"carousel-inner\">
      ";
        // line 13
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(($context["items"] ?? null));
        foreach ($context['_seq'] as $context["index"] => $context["item"]) {
            // line 14
            yield "        ";
            if (CoreExtension::matches("/^\\d+\$/", $context["index"])) {
                // line 15
                yield "          <div class=\"carousel-item";
                if (($context["index"] == 0)) {
                    yield " active";
                }
                yield "\">
            ";
                // line 16
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $context["item"], "html", null, true);
                yield "
          </div>
        ";
            }
            // line 19
            yield "      ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['index'], $context['item'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 20
        yield "    </div>

    <!-- Controls/Prev & Next -->
    <button class=\"carousel-control-prev\" type=\"button\" data-bs-target=\"#myCarousel\" data-bs-slide=\"prev\">
      <img src=\"/themes/custom/dna/assets/icons/arrow_icon.svg\" alt=\"\" role=\"presentation\">
    </button>
    <button class=\"carousel-control-next\" type=\"button\" data-bs-target=\"#myCarousel\" data-bs-slide=\"next\">
      <img src=\"/themes/custom/dna/assets/icons/arrow_icon.svg\" alt=\"\" role=\"presentation\">
    </button>
  </div>

    ";
        // line 31
        if (( !Twig\Extension\CoreExtension::testEmpty(($context["primary_button_text"] ?? null)) ||  !Twig\Extension\CoreExtension::testEmpty(($context["secondary_button_text"] ?? null)))) {
            // line 32
            yield "      <div class=\"carousel_cta d-flex align-items-center justify-content-center mt-5 flex-wrap\">
        ";
            // line 33
            if ( !Twig\Extension\CoreExtension::testEmpty(($context["primary_button_text"] ?? null))) {
                // line 34
                yield "          ";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(Twig\Extension\CoreExtension::include($this->env, $context, "dna:button", ["text" =>                 // line 35
($context["primary_button_text"] ?? null), "url" =>                 // line 36
($context["primary_button_url"] ?? null), "additionalClasses" => "btn-primary"]));
                // line 38
                yield "
        ";
            }
            // line 40
            yield "        ";
            if ( !Twig\Extension\CoreExtension::testEmpty(($context["secondary_button_text"] ?? null))) {
                // line 41
                yield "          ";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(Twig\Extension\CoreExtension::include($this->env, $context, "dna:button", ["text" =>                 // line 42
($context["secondary_button_text"] ?? null), "url" =>                 // line 43
($context["secondary_button_url"] ?? null), "additionalClasses" => "btn-outline-primary"]));
                // line 45
                yield "
        ";
            }
            // line 47
            yield "      </div>
    ";
        }
        // line 49
        yield "  <div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const carousel = document.getElementById('myCarousel');
    const iframes = carousel.querySelectorAll('iframe');
    const players = Array.from(iframes).map((iframe) => new Vimeo.Player(iframe));

    carousel.addEventListener('slide.bs.carousel', function () {
      players.forEach(player => {
        player.pause().catch(() => {});
      });
    });
  });
</script>

<script src=\"https://player.vimeo.com/api/player.js\"></script>
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["eyebrow", "title", "items", "primary_button_text", "secondary_button_text", "primary_button_url", "secondary_button_url"]);        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "dna:carousel";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  148 => 49,  144 => 47,  140 => 45,  138 => 43,  137 => 42,  135 => 41,  132 => 40,  128 => 38,  126 => 36,  125 => 35,  123 => 34,  121 => 33,  118 => 32,  116 => 31,  103 => 20,  97 => 19,  91 => 16,  84 => 15,  81 => 14,  77 => 13,  71 => 9,  65 => 7,  63 => 6,  60 => 5,  54 => 3,  52 => 2,  44 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "dna:carousel", "themes/custom/dna/components/carousel/carousel.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["if" => 2, "for" => 13];
        static $filters = ["escape" => 3];
        static $functions = ["include" => 34];

        try {
            $this->sandbox->checkSecurity(
                ['if', 'for'],
                ['escape'],
                ['include'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
