<?php

namespace Drupal\dna_migration\Plugin\migrate\source;

use Drupal\file\Plugin\migrate\source\d7\File;

/**
 * Drupal 7 file source (optionally filtered by type) from database.
 *
 * @MigrateSource(
 *   id = "dna_d7_filtered_file",
 *   source_module = "file"
 * )
 */
class FilteredFile extends File {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();

    if (isset($this->configuration['type'])) {
      $query->condition('f.type', $this->configuration['type']);
    }

    if (isset($this->configuration['get_alt'])) {
      $alt_alias = $query->addJoin('left', 'field_data_field_file_image_alt_text', 'alt', 'f.fid = %alias.entity_id');
      $query->addField($alt_alias, 'field_file_image_alt_text_value', 'alt');
    }

    if (isset($this->configuration['get_pictures_alt'])) {
      $alt_alias = $query->addJoin('left', 'field_data_field_file_pictures_alt_text', 'alt', 'f.fid = %alias.entity_id');
      $query->addField($alt_alias, 'field_file_pictures_alt_text_value', 'pictures-alt');
    }

    if (isset($this->configuration['get_title'])) {
      $title_alias = $query->addJoin('left', 'field_data_field_file_image_title_text', 'title', 'f.fid = %alias.entity_id');
      $query->addField($title_alias, 'field_file_image_title_text_value', 'title');
    }
    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function fields() {
    $fields = parent::fields();
    $fields['type'] = $this->t('The type of file.');
    $fields['alt'] = $this->t('Alt text of the file (if present)');
    $fields['pictures-alt'] = $this->t('Alt text of the pictures (if present)');
    $fields['title'] = $this->t('Title text of the file (if present)');
    return $fields;
  }
}
