<?php

namespace Drupal\dna_migration\Plugin\migrate\process;

use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\Row;

/**
 * Formats the resource type value as required.
 *
 * @MigrateProcessPlugin(
 *   id = "resource_type_formatter"
 * )
 */
class ResourceTypeFormatter extends ProcessPluginBase {

  /**
   * Transforms the resource type value into the desired structure.
   *
   * @param mixed $value
   *   The resource type value from the source data (either 'Standard' or 'Feature').
   * @param \Drupal\migrate\MigrateExecutableInterface $migrate_executable
   *   The migrate executable.
   * @param \Drupal\migrate\Row $row
   *   The row object.
   * @param string $destination_property
   *   The destination field property.
   *
   * @return string|null
   *   The formatted resource type value or NULL if empty.
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    // If the value is empty, return NULL
    if (empty($value)) {
      return NULL;
    }

    if(is_null($value['value'])) {
      return NULL;
    }

    return $value['value'];
  }
}
