<?php

namespace Drupal\dna_migration\Plugin\migrate\process;

use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\Row;
use Drupal\Core\Url;

/**
 * Formats a URL field properly for migration.
 *
 * @MigrateProcessPlugin(
 *   id = "link_formatter"
 * )
 */
class LinkFormatter extends ProcessPluginBase {

  /**
   * Transforms the given URL into a valid Drupal link field.
   *
   * @param mixed $value
   *   The URL value from the source data.
   * @param \Drupal\migrate\MigrateExecutableInterface $migrate_executable
   *   The migrate executable.
   * @param \Drupal\migrate\Row $row
   *   The row object.
   * @param string $destination_property
   *   The destination field property.
   *
   * @return array|null
   *   The formatted URL array or NULL if empty.
   *
   * @throws \Drupal\migrate\MigrateException
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    if (empty($value)) {
      return NULL;
    }

    // Ensure the URL has a valid scheme.
    if (strpos($value, 'http') !== 0) {
      $value = 'https://' . $value;
    }

    return [
      'uri' => $value,
      'title' => $row->getSourceProperty('field_cpd_training_link/0/title') ?? '',
    ];
  }
}
