<?php

namespace Drupal\dna_migration\Plugin\migrate\process;

use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\Row;
use Drupal\Core\Url;

/**
 * Custom process plugin to set URL based on destination_nid.
 *
 * @MigrateProcessPlugin(
 *   id = "custom_link_process"
 * )
 */
class CustomLinkProcessPlugin extends ProcessPluginBase {

  /**
   * Transforms the value of the source field.
   *
   * @param mixed $value
   *   The value to process.
   * @param \Drupal\migrate\MigrateExecutableInterface $migrate_executable
   *   The migration executable.
   * @param \Drupal\migrate\Row $row
   *   The row being processed.
   * @param string $destination_property
   *   The destination property being set.
   *
   * @return mixed
   *   The processed value.
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    // Check if the value (destination_nid) is empty or null.
    if (empty($value)) {
      return 'route:<nolink>';  // Fallback to 'nolink' if destination_nid is null or empty.
    }

    // Otherwise, concatenate the entity prefix with the destination_nid.
    $entity_prefix = 'entity:node/';
    return $entity_prefix . $value;
  }
}
