<?php

namespace Drupal\search_api\Plugin\search_api\processor\Resources;

/**
 * Represents characters of the Unicode category "So" ("Symbol, Other").
 */
class So implements UnicodeCharacterPropertyInterface {

  /**
   * {@inheritdoc}
   */
  public static function getRegularExpression() {
    // phpcs:disable
    // cspell:disable
    return
      '\x{00A6}\x{00A9}\x{00AE}\x{00B0}\x{0482}\x{060E}\x{060F}' .
      '\x{06DE}\x{06E9}\x{06FD}\x{06FE}\x{07F6}\x{09FA}\x{0B70}' .
      '\x{0BF3}\x{0BF4}\x{0BF5}\x{0BF6}\x{0BF7}\x{0BF8}\x{0BFA}' .
      '\x{0C7F}\x{0D79}\x{0F01}\x{0F02}\x{0F03}\x{0F13}\x{0F15}' .
      '\x{0F16}\x{0F17}\x{0F1A}\x{0F1B}\x{0F1C}\x{0F1D}\x{0F1E}' .
      '\x{0F1F}\x{0F34}\x{0F36}\x{0F38}\x{0FBE}\x{0FBF}\x{0FC0}' .
      '\x{0FC1}\x{0FC2}\x{0FC3}\x{0FC4}\x{0FC5}\x{0FC7}\x{0FC8}' .
      '\x{0FC9}\x{0FCA}\x{0FCB}\x{0FCC}\x{0FCE}\x{0FCF}\x{0FD5}' .
      '\x{0FD6}\x{0FD7}\x{0FD8}\x{109E}\x{109F}\x{1390}\x{1391}' .
      '\x{1392}\x{1393}\x{1394}\x{1395}\x{1396}\x{1397}\x{1398}' .
      '\x{1399}\x{1940}\x{19DE}\x{19DF}\x{19E0}\x{19E1}\x{19E2}' .
      '\x{19E3}\x{19E4}\x{19E5}\x{19E6}\x{19E7}\x{19E8}\x{19E9}' .
      '\x{19EA}\x{19EB}\x{19EC}\x{19ED}\x{19EE}\x{19EF}\x{19F0}' .
      '\x{19F1}\x{19F2}\x{19F3}\x{19F4}\x{19F5}\x{19F6}\x{19F7}' .
      '\x{19F8}\x{19F9}\x{19FA}\x{19FB}\x{19FC}\x{19FD}\x{19FE}' .
      '\x{19FF}\x{1B61}\x{1B62}\x{1B63}\x{1B64}\x{1B65}\x{1B66}' .
      '\x{1B67}\x{1B68}\x{1B69}\x{1B6A}\x{1B74}\x{1B75}\x{1B76}' .
      '\x{1B77}\x{1B78}\x{1B79}\x{1B7A}\x{1B7B}\x{1B7C}\x{2100}' .
      '\x{2101}\x{2103}\x{2104}\x{2105}\x{2106}\x{2108}\x{2109}' .
      '\x{2114}\x{2116}\x{2117}\x{211E}\x{211F}\x{2120}\x{2121}' .
      '\x{2122}\x{2123}\x{2125}\x{2127}\x{2129}\x{212E}\x{213A}' .
      '\x{213B}\x{214A}\x{214C}\x{214D}\x{214F}\x{2195}\x{2196}' .
      '\x{2197}\x{2198}\x{2199}\x{219C}\x{219D}\x{219E}\x{219F}' .
      '\x{21A1}\x{21A2}\x{21A4}\x{21A5}\x{21A7}\x{21A8}\x{21A9}' .
      '\x{21AA}\x{21AB}\x{21AC}\x{21AD}\x{21AF}\x{21B0}\x{21B1}' .
      '\x{21B2}\x{21B3}\x{21B4}\x{21B5}\x{21B6}\x{21B7}\x{21B8}' .
      '\x{21B9}\x{21BA}\x{21BB}\x{21BC}\x{21BD}\x{21BE}\x{21BF}' .
      '\x{21C0}\x{21C1}\x{21C2}\x{21C3}\x{21C4}\x{21C5}\x{21C6}' .
      '\x{21C7}\x{21C8}\x{21C9}\x{21CA}\x{21CB}\x{21CC}\x{21CD}' .
      '\x{21D0}\x{21D1}\x{21D3}\x{21D5}\x{21D6}\x{21D7}\x{21D8}' .
      '\x{21D9}\x{21DA}\x{21DB}\x{21DC}\x{21DD}\x{21DE}\x{21DF}' .
      '\x{21E0}\x{21E1}\x{21E2}\x{21E3}\x{21E4}\x{21E5}\x{21E6}' .
      '\x{21E7}\x{21E8}\x{21E9}\x{21EA}\x{21EB}\x{21EC}\x{21ED}' .
      '\x{21EE}\x{21EF}\x{21F0}\x{21F1}\x{21F2}\x{21F3}\x{2300}' .
      '\x{2301}\x{2302}\x{2303}\x{2304}\x{2305}\x{2306}\x{2307}' .
      '\x{230C}\x{230D}\x{230E}\x{230F}\x{2310}\x{2311}\x{2312}' .
      '\x{2313}\x{2314}\x{2315}\x{2316}\x{2317}\x{2318}\x{2319}' .
      '\x{231A}\x{231B}\x{231C}\x{231D}\x{231E}\x{231F}\x{2322}' .
      '\x{2323}\x{2324}\x{2325}\x{2326}\x{2327}\x{2328}\x{232B}' .
      '\x{232C}\x{232D}\x{232E}\x{232F}\x{2330}\x{2331}\x{2332}' .
      '\x{2333}\x{2334}\x{2335}\x{2336}\x{2337}\x{2338}\x{2339}' .
      '\x{233A}\x{233B}\x{233C}\x{233D}\x{233E}\x{233F}\x{2340}' .
      '\x{2341}\x{2342}\x{2343}\x{2344}\x{2345}\x{2346}\x{2347}' .
      '\x{2348}\x{2349}\x{234A}\x{234B}\x{234C}\x{234D}\x{234E}' .
      '\x{234F}\x{2350}\x{2351}\x{2352}\x{2353}\x{2354}\x{2355}' .
      '\x{2356}\x{2357}\x{2358}\x{2359}\x{235A}\x{235B}\x{235C}' .
      '\x{235D}\x{235E}\x{235F}\x{2360}\x{2361}\x{2362}\x{2363}' .
      '\x{2364}\x{2365}\x{2366}\x{2367}\x{2368}\x{2369}\x{236A}' .
      '\x{236B}\x{236C}\x{236D}\x{236E}\x{236F}\x{2370}\x{2371}' .
      '\x{2372}\x{2373}\x{2374}\x{2375}\x{2376}\x{2377}\x{2378}' .
      '\x{2379}\x{237A}\x{237B}\x{237D}\x{237E}\x{237F}\x{2380}' .
      '\x{2381}\x{2382}\x{2383}\x{2384}\x{2385}\x{2386}\x{2387}' .
      '\x{2388}\x{2389}\x{238A}\x{238B}\x{238C}\x{238D}\x{238E}' .
      '\x{238F}\x{2390}\x{2391}\x{2392}\x{2393}\x{2394}\x{2395}' .
      '\x{2396}\x{2397}\x{2398}\x{2399}\x{239A}\x{23B4}\x{23B5}' .
      '\x{23B6}\x{23B7}\x{23B8}\x{23B9}\x{23BA}\x{23BB}\x{23BC}' .
      '\x{23BD}\x{23BE}\x{23BF}\x{23C0}\x{23C1}\x{23C2}\x{23C3}' .
      '\x{23C4}\x{23C5}\x{23C6}\x{23C7}\x{23C8}\x{23C9}\x{23CA}' .
      '\x{23CB}\x{23CC}\x{23CD}\x{23CE}\x{23CF}\x{23D0}\x{23D1}' .
      '\x{23D2}\x{23D3}\x{23D4}\x{23D5}\x{23D6}\x{23D7}\x{23D8}' .
      '\x{23D9}\x{23DA}\x{23DB}\x{23E2}\x{23E3}\x{23E4}\x{23E5}' .
      '\x{23E6}\x{23E7}\x{23E8}\x{23E9}\x{23EA}\x{23EB}\x{23EC}' .
      '\x{23ED}\x{23EE}\x{23EF}\x{23F0}\x{23F1}\x{23F2}\x{23F3}' .
      '\x{2400}\x{2401}\x{2402}\x{2403}\x{2404}\x{2405}\x{2406}' .
      '\x{2407}\x{2408}\x{2409}\x{240A}\x{240B}\x{240C}\x{240D}' .
      '\x{240E}\x{240F}\x{2410}\x{2411}\x{2412}\x{2413}\x{2414}' .
      '\x{2415}\x{2416}\x{2417}\x{2418}\x{2419}\x{241A}\x{241B}' .
      '\x{241C}\x{241D}\x{241E}\x{241F}\x{2420}\x{2421}\x{2422}' .
      '\x{2423}\x{2424}\x{2425}\x{2426}\x{2440}\x{2441}\x{2442}' .
      '\x{2443}\x{2444}\x{2445}\x{2446}\x{2447}\x{2448}\x{2449}' .
      '\x{244A}\x{249C}\x{249D}\x{249E}\x{249F}\x{24A0}\x{24A1}' .
      '\x{24A2}\x{24A3}\x{24A4}\x{24A5}\x{24A6}\x{24A7}\x{24A8}' .
      '\x{24A9}\x{24AA}\x{24AB}\x{24AC}\x{24AD}\x{24AE}\x{24AF}' .
      '\x{24B0}\x{24B1}\x{24B2}\x{24B3}\x{24B4}\x{24B5}\x{24B6}' .
      '\x{24B7}\x{24B8}\x{24B9}\x{24BA}\x{24BB}\x{24BC}\x{24BD}' .
      '\x{24BE}\x{24BF}\x{24C0}\x{24C1}\x{24C2}\x{24C3}\x{24C4}' .
      '\x{24C5}\x{24C6}\x{24C7}\x{24C8}\x{24C9}\x{24CA}\x{24CB}' .
      '\x{24CC}\x{24CD}\x{24CE}\x{24CF}\x{24D0}\x{24D1}\x{24D2}' .
      '\x{24D3}\x{24D4}\x{24D5}\x{24D6}\x{24D7}\x{24D8}\x{24D9}' .
      '\x{24DA}\x{24DB}\x{24DC}\x{24DD}\x{24DE}\x{24DF}\x{24E0}' .
      '\x{24E1}\x{24E2}\x{24E3}\x{24E4}\x{24E5}\x{24E6}\x{24E7}' .
      '\x{24E8}\x{24E9}\x{2500}\x{2501}\x{2502}\x{2503}\x{2504}' .
      '\x{2505}\x{2506}\x{2507}\x{2508}\x{2509}\x{250A}\x{250B}' .
      '\x{250C}\x{250D}\x{250E}\x{250F}\x{2510}\x{2511}\x{2512}' .
      '\x{2513}\x{2514}\x{2515}\x{2516}\x{2517}\x{2518}\x{2519}' .
      '\x{251A}\x{251B}\x{251C}\x{251D}\x{251E}\x{251F}\x{2520}' .
      '\x{2521}\x{2522}\x{2523}\x{2524}\x{2525}\x{2526}\x{2527}' .
      '\x{2528}\x{2529}\x{252A}\x{252B}\x{252C}\x{252D}\x{252E}' .
      '\x{252F}\x{2530}\x{2531}\x{2532}\x{2533}\x{2534}\x{2535}' .
      '\x{2536}\x{2537}\x{2538}\x{2539}\x{253A}\x{253B}\x{253C}' .
      '\x{253D}\x{253E}\x{253F}\x{2540}\x{2541}\x{2542}\x{2543}' .
      '\x{2544}\x{2545}\x{2546}\x{2547}\x{2548}\x{2549}\x{254A}' .
      '\x{254B}\x{254C}\x{254D}\x{254E}\x{254F}\x{2550}\x{2551}' .
      '\x{2552}\x{2553}\x{2554}\x{2555}\x{2556}\x{2557}\x{2558}' .
      '\x{2559}\x{255A}\x{255B}\x{255C}\x{255D}\x{255E}\x{255F}' .
      '\x{2560}\x{2561}\x{2562}\x{2563}\x{2564}\x{2565}\x{2566}' .
      '\x{2567}\x{2568}\x{2569}\x{256A}\x{256B}\x{256C}\x{256D}' .
      '\x{256E}\x{256F}\x{2570}\x{2571}\x{2572}\x{2573}\x{2574}' .
      '\x{2575}\x{2576}\x{2577}\x{2578}\x{2579}\x{257A}\x{257B}' .
      '\x{257C}\x{257D}\x{257E}\x{257F}\x{2580}\x{2581}\x{2582}' .
      '\x{2583}\x{2584}\x{2585}\x{2586}\x{2587}\x{2588}\x{2589}' .
      '\x{258A}\x{258B}\x{258C}\x{258D}\x{258E}\x{258F}\x{2590}' .
      '\x{2591}\x{2592}\x{2593}\x{2594}\x{2595}\x{2596}\x{2597}' .
      '\x{2598}\x{2599}\x{259A}\x{259B}\x{259C}\x{259D}\x{259E}' .
      '\x{259F}\x{25A0}\x{25A1}\x{25A2}\x{25A3}\x{25A4}\x{25A5}' .
      '\x{25A6}\x{25A7}\x{25A8}\x{25A9}\x{25AA}\x{25AB}\x{25AC}' .
      '\x{25AD}\x{25AE}\x{25AF}\x{25B0}\x{25B1}\x{25B2}\x{25B3}' .
      '\x{25B4}\x{25B5}\x{25B6}\x{25B8}\x{25B9}\x{25BA}\x{25BB}' .
      '\x{25BC}\x{25BD}\x{25BE}\x{25BF}\x{25C0}\x{25C2}\x{25C3}' .
      '\x{25C4}\x{25C5}\x{25C6}\x{25C7}\x{25C8}\x{25C9}\x{25CA}' .
      '\x{25CB}\x{25CC}\x{25CD}\x{25CE}\x{25CF}\x{25D0}\x{25D1}' .
      '\x{25D2}\x{25D3}\x{25D4}\x{25D5}\x{25D6}\x{25D7}\x{25D8}' .
      '\x{25D9}\x{25DA}\x{25DB}\x{25DC}\x{25DD}\x{25DE}\x{25DF}' .
      '\x{25E0}\x{25E1}\x{25E2}\x{25E3}\x{25E4}\x{25E5}\x{25E6}' .
      '\x{25E7}\x{25E8}\x{25E9}\x{25EA}\x{25EB}\x{25EC}\x{25ED}' .
      '\x{25EE}\x{25EF}\x{25F0}\x{25F1}\x{25F2}\x{25F3}\x{25F4}' .
      '\x{25F5}\x{25F6}\x{25F7}\x{2600}\x{2601}\x{2602}\x{2603}' .
      '\x{2604}\x{2605}\x{2606}\x{2607}\x{2608}\x{2609}\x{260A}' .
      '\x{260B}\x{260C}\x{260D}\x{260E}\x{260F}\x{2610}\x{2611}' .
      '\x{2612}\x{2613}\x{2614}\x{2615}\x{2616}\x{2617}\x{2618}' .
      '\x{2619}\x{261A}\x{261B}\x{261C}\x{261D}\x{261E}\x{261F}' .
      '\x{2620}\x{2621}\x{2622}\x{2623}\x{2624}\x{2625}\x{2626}' .
      '\x{2627}\x{2628}\x{2629}\x{262A}\x{262B}\x{262C}\x{262D}' .
      '\x{262E}\x{262F}\x{2630}\x{2631}\x{2632}\x{2633}\x{2634}' .
      '\x{2635}\x{2636}\x{2637}\x{2638}\x{2639}\x{263A}\x{263B}' .
      '\x{263C}\x{263D}\x{263E}\x{263F}\x{2640}\x{2641}\x{2642}' .
      '\x{2643}\x{2644}\x{2645}\x{2646}\x{2647}\x{2648}\x{2649}' .
      '\x{264A}\x{264B}\x{264C}\x{264D}\x{264E}\x{264F}\x{2650}' .
      '\x{2651}\x{2652}\x{2653}\x{2654}\x{2655}\x{2656}\x{2657}' .
      '\x{2658}\x{2659}\x{265A}\x{265B}\x{265C}\x{265D}\x{265E}' .
      '\x{265F}\x{2660}\x{2661}\x{2662}\x{2663}\x{2664}\x{2665}' .
      '\x{2666}\x{2667}\x{2668}\x{2669}\x{266A}\x{266B}\x{266C}' .
      '\x{266D}\x{266E}\x{2670}\x{2671}\x{2672}\x{2673}\x{2674}' .
      '\x{2675}\x{2676}\x{2677}\x{2678}\x{2679}\x{267A}\x{267B}' .
      '\x{267C}\x{267D}\x{267E}\x{267F}\x{2680}\x{2681}\x{2682}' .
      '\x{2683}\x{2684}\x{2685}\x{2686}\x{2687}\x{2688}\x{2689}' .
      '\x{268A}\x{268B}\x{268C}\x{268D}\x{268E}\x{268F}\x{2690}' .
      '\x{2691}\x{2692}\x{2693}\x{2694}\x{2695}\x{2696}\x{2697}' .
      '\x{2698}\x{2699}\x{269A}\x{269B}\x{269C}\x{269D}\x{269E}' .
      '\x{269F}\x{26A0}\x{26A1}\x{26A2}\x{26A3}\x{26A4}\x{26A5}' .
      '\x{26A6}\x{26A7}\x{26A8}\x{26A9}\x{26AA}\x{26AB}\x{26AC}' .
      '\x{26AD}\x{26AE}\x{26AF}\x{26B0}\x{26B1}\x{26B2}\x{26B3}' .
      '\x{26B4}\x{26B5}\x{26B6}\x{26B7}\x{26B8}\x{26B9}\x{26BA}' .
      '\x{26BB}\x{26BC}\x{26BD}\x{26BE}\x{26BF}\x{26C0}\x{26C1}' .
      '\x{26C2}\x{26C3}\x{26C4}\x{26C5}\x{26C6}\x{26C7}\x{26C8}' .
      '\x{26C9}\x{26CA}\x{26CB}\x{26CC}\x{26CD}\x{26CE}\x{26CF}' .
      '\x{26D0}\x{26D1}\x{26D2}\x{26D3}\x{26D4}\x{26D5}\x{26D6}' .
      '\x{26D7}\x{26D8}\x{26D9}\x{26DA}\x{26DB}\x{26DC}\x{26DD}' .
      '\x{26DE}\x{26DF}\x{26E0}\x{26E1}\x{26E2}\x{26E3}\x{26E4}' .
      '\x{26E5}\x{26E6}\x{26E7}\x{26E8}\x{26E9}\x{26EA}\x{26EB}' .
      '\x{26EC}\x{26ED}\x{26EE}\x{26EF}\x{26F0}\x{26F1}\x{26F2}' .
      '\x{26F3}\x{26F4}\x{26F5}\x{26F6}\x{26F7}\x{26F8}\x{26F9}' .
      '\x{26FA}\x{26FB}\x{26FC}\x{26FD}\x{26FE}\x{26FF}\x{2701}' .
      '\x{2702}\x{2703}\x{2704}\x{2705}\x{2706}\x{2707}\x{2708}' .
      '\x{2709}\x{270A}\x{270B}\x{270C}\x{270D}\x{270E}\x{270F}' .
      '\x{2710}\x{2711}\x{2712}\x{2713}\x{2714}\x{2715}\x{2716}' .
      '\x{2717}\x{2718}\x{2719}\x{271A}\x{271B}\x{271C}\x{271D}' .
      '\x{271E}\x{271F}\x{2720}\x{2721}\x{2722}\x{2723}\x{2724}' .
      '\x{2725}\x{2726}\x{2727}\x{2728}\x{2729}\x{272A}\x{272B}' .
      '\x{272C}\x{272D}\x{272E}\x{272F}\x{2730}\x{2731}\x{2732}' .
      '\x{2733}\x{2734}\x{2735}\x{2736}\x{2737}\x{2738}\x{2739}' .
      '\x{273A}\x{273B}\x{273C}\x{273D}\x{273E}\x{273F}\x{2740}' .
      '\x{2741}\x{2742}\x{2743}\x{2744}\x{2745}\x{2746}\x{2747}' .
      '\x{2748}\x{2749}\x{274A}\x{274B}\x{274C}\x{274D}\x{274E}' .
      '\x{274F}\x{2750}\x{2751}\x{2752}\x{2753}\x{2754}\x{2755}' .
      '\x{2756}\x{2757}\x{2758}\x{2759}\x{275A}\x{275B}\x{275C}' .
      '\x{275D}\x{275E}\x{275F}\x{2760}\x{2761}\x{2762}\x{2763}' .
      '\x{2764}\x{2765}\x{2766}\x{2767}\x{2794}\x{2795}\x{2796}' .
      '\x{2797}\x{2798}\x{2799}\x{279A}\x{279B}\x{279C}\x{279D}' .
      '\x{279E}\x{279F}\x{27A0}\x{27A1}\x{27A2}\x{27A3}\x{27A4}' .
      '\x{27A5}\x{27A6}\x{27A7}\x{27A8}\x{27A9}\x{27AA}\x{27AB}' .
      '\x{27AC}\x{27AD}\x{27AE}\x{27AF}\x{27B0}\x{27B1}\x{27B2}' .
      '\x{27B3}\x{27B4}\x{27B5}\x{27B6}\x{27B7}\x{27B8}\x{27B9}' .
      '\x{27BA}\x{27BB}\x{27BC}\x{27BD}\x{27BE}\x{27BF}\x{2800}' .
      '\x{2801}\x{2802}\x{2803}\x{2804}\x{2805}\x{2806}\x{2807}' .
      '\x{2808}\x{2809}\x{280A}\x{280B}\x{280C}\x{280D}\x{280E}' .
      '\x{280F}\x{2810}\x{2811}\x{2812}\x{2813}\x{2814}\x{2815}' .
      '\x{2816}\x{2817}\x{2818}\x{2819}\x{281A}\x{281B}\x{281C}' .
      '\x{281D}\x{281E}\x{281F}\x{2820}\x{2821}\x{2822}\x{2823}' .
      '\x{2824}\x{2825}\x{2826}\x{2827}\x{2828}\x{2829}\x{282A}' .
      '\x{282B}\x{282C}\x{282D}\x{282E}\x{282F}\x{2830}\x{2831}' .
      '\x{2832}\x{2833}\x{2834}\x{2835}\x{2836}\x{2837}\x{2838}' .
      '\x{2839}\x{283A}\x{283B}\x{283C}\x{283D}\x{283E}\x{283F}' .
      '\x{2840}\x{2841}\x{2842}\x{2843}\x{2844}\x{2845}\x{2846}' .
      '\x{2847}\x{2848}\x{2849}\x{284A}\x{284B}\x{284C}\x{284D}' .
      '\x{284E}\x{284F}\x{2850}\x{2851}\x{2852}\x{2853}\x{2854}' .
      '\x{2855}\x{2856}\x{2857}\x{2858}\x{2859}\x{285A}\x{285B}' .
      '\x{285C}\x{285D}\x{285E}\x{285F}\x{2860}\x{2861}\x{2862}' .
      '\x{2863}\x{2864}\x{2865}\x{2866}\x{2867}\x{2868}\x{2869}' .
      '\x{286A}\x{286B}\x{286C}\x{286D}\x{286E}\x{286F}\x{2870}' .
      '\x{2871}\x{2872}\x{2873}\x{2874}\x{2875}\x{2876}\x{2877}' .
      '\x{2878}\x{2879}\x{287A}\x{287B}\x{287C}\x{287D}\x{287E}' .
      '\x{287F}\x{2880}\x{2881}\x{2882}\x{2883}\x{2884}\x{2885}' .
      '\x{2886}\x{2887}\x{2888}\x{2889}\x{288A}\x{288B}\x{288C}' .
      '\x{288D}\x{288E}\x{288F}\x{2890}\x{2891}\x{2892}\x{2893}' .
      '\x{2894}\x{2895}\x{2896}\x{2897}\x{2898}\x{2899}\x{289A}' .
      '\x{289B}\x{289C}\x{289D}\x{289E}\x{289F}\x{28A0}\x{28A1}' .
      '\x{28A2}\x{28A3}\x{28A4}\x{28A5}\x{28A6}\x{28A7}\x{28A8}' .
      '\x{28A9}\x{28AA}\x{28AB}\x{28AC}\x{28AD}\x{28AE}\x{28AF}' .
      '\x{28B0}\x{28B1}\x{28B2}\x{28B3}\x{28B4}\x{28B5}\x{28B6}' .
      '\x{28B7}\x{28B8}\x{28B9}\x{28BA}\x{28BB}\x{28BC}\x{28BD}' .
      '\x{28BE}\x{28BF}\x{28C0}\x{28C1}\x{28C2}\x{28C3}\x{28C4}' .
      '\x{28C5}\x{28C6}\x{28C7}\x{28C8}\x{28C9}\x{28CA}\x{28CB}' .
      '\x{28CC}\x{28CD}\x{28CE}\x{28CF}\x{28D0}\x{28D1}\x{28D2}' .
      '\x{28D3}\x{28D4}\x{28D5}\x{28D6}\x{28D7}\x{28D8}\x{28D9}' .
      '\x{28DA}\x{28DB}\x{28DC}\x{28DD}\x{28DE}\x{28DF}\x{28E0}' .
      '\x{28E1}\x{28E2}\x{28E3}\x{28E4}\x{28E5}\x{28E6}\x{28E7}' .
      '\x{28E8}\x{28E9}\x{28EA}\x{28EB}\x{28EC}\x{28ED}\x{28EE}' .
      '\x{28EF}\x{28F0}\x{28F1}\x{28F2}\x{28F3}\x{28F4}\x{28F5}' .
      '\x{28F6}\x{28F7}\x{28F8}\x{28F9}\x{28FA}\x{28FB}\x{28FC}' .
      '\x{28FD}\x{28FE}\x{28FF}\x{2B00}\x{2B01}\x{2B02}\x{2B03}' .
      '\x{2B04}\x{2B05}\x{2B06}\x{2B07}\x{2B08}\x{2B09}\x{2B0A}' .
      '\x{2B0B}\x{2B0C}\x{2B0D}\x{2B0E}\x{2B0F}\x{2B10}\x{2B11}' .
      '\x{2B12}\x{2B13}\x{2B14}\x{2B15}\x{2B16}\x{2B17}\x{2B18}' .
      '\x{2B19}\x{2B1A}\x{2B1B}\x{2B1C}\x{2B1D}\x{2B1E}\x{2B1F}' .
      '\x{2B20}\x{2B21}\x{2B22}\x{2B23}\x{2B24}\x{2B25}\x{2B26}' .
      '\x{2B27}\x{2B28}\x{2B29}\x{2B2A}\x{2B2B}\x{2B2C}\x{2B2D}' .
      '\x{2B2E}\x{2B2F}\x{2B45}\x{2B46}\x{2B50}\x{2B51}\x{2B52}' .
      '\x{2B53}\x{2B54}\x{2B55}\x{2B56}\x{2B57}\x{2B58}\x{2B59}' .
      '\x{2CE5}\x{2CE6}\x{2CE7}\x{2CE8}\x{2CE9}\x{2CEA}\x{2E80}' .
      '\x{2E81}\x{2E82}\x{2E83}\x{2E84}\x{2E85}\x{2E86}\x{2E87}' .
      '\x{2E88}\x{2E89}\x{2E8A}\x{2E8B}\x{2E8C}\x{2E8D}\x{2E8E}' .
      '\x{2E8F}\x{2E90}\x{2E91}\x{2E92}\x{2E93}\x{2E94}\x{2E95}' .
      '\x{2E96}\x{2E97}\x{2E98}\x{2E99}\x{2E9B}\x{2E9C}\x{2E9D}' .
      '\x{2E9E}\x{2E9F}\x{2EA0}\x{2EA1}\x{2EA2}\x{2EA3}\x{2EA4}' .
      '\x{2EA5}\x{2EA6}\x{2EA7}\x{2EA8}\x{2EA9}\x{2EAA}\x{2EAB}' .
      '\x{2EAC}\x{2EAD}\x{2EAE}\x{2EAF}\x{2EB0}\x{2EB1}\x{2EB2}' .
      '\x{2EB3}\x{2EB4}\x{2EB5}\x{2EB6}\x{2EB7}\x{2EB8}\x{2EB9}' .
      '\x{2EBA}\x{2EBB}\x{2EBC}\x{2EBD}\x{2EBE}\x{2EBF}\x{2EC0}' .
      '\x{2EC1}\x{2EC2}\x{2EC3}\x{2EC4}\x{2EC5}\x{2EC6}\x{2EC7}' .
      '\x{2EC8}\x{2EC9}\x{2ECA}\x{2ECB}\x{2ECC}\x{2ECD}\x{2ECE}' .
      '\x{2ECF}\x{2ED0}\x{2ED1}\x{2ED2}\x{2ED3}\x{2ED4}\x{2ED5}' .
      '\x{2ED6}\x{2ED7}\x{2ED8}\x{2ED9}\x{2EDA}\x{2EDB}\x{2EDC}' .
      '\x{2EDD}\x{2EDE}\x{2EDF}\x{2EE0}\x{2EE1}\x{2EE2}\x{2EE3}' .
      '\x{2EE4}\x{2EE5}\x{2EE6}\x{2EE7}\x{2EE8}\x{2EE9}\x{2EEA}' .
      '\x{2EEB}\x{2EEC}\x{2EED}\x{2EEE}\x{2EEF}\x{2EF0}\x{2EF1}' .
      '\x{2EF2}\x{2EF3}\x{2F00}\x{2F01}\x{2F02}\x{2F03}\x{2F04}' .
      '\x{2F05}\x{2F06}\x{2F07}\x{2F08}\x{2F09}\x{2F0A}\x{2F0B}' .
      '\x{2F0C}\x{2F0D}\x{2F0E}\x{2F0F}\x{2F10}\x{2F11}\x{2F12}' .
      '\x{2F13}\x{2F14}\x{2F15}\x{2F16}\x{2F17}\x{2F18}\x{2F19}' .
      '\x{2F1A}\x{2F1B}\x{2F1C}\x{2F1D}\x{2F1E}\x{2F1F}\x{2F20}' .
      '\x{2F21}\x{2F22}\x{2F23}\x{2F24}\x{2F25}\x{2F26}\x{2F27}' .
      '\x{2F28}\x{2F29}\x{2F2A}\x{2F2B}\x{2F2C}\x{2F2D}\x{2F2E}' .
      '\x{2F2F}\x{2F30}\x{2F31}\x{2F32}\x{2F33}\x{2F34}\x{2F35}' .
      '\x{2F36}\x{2F37}\x{2F38}\x{2F39}\x{2F3A}\x{2F3B}\x{2F3C}' .
      '\x{2F3D}\x{2F3E}\x{2F3F}\x{2F40}\x{2F41}\x{2F42}\x{2F43}' .
      '\x{2F44}\x{2F45}\x{2F46}\x{2F47}\x{2F48}\x{2F49}\x{2F4A}' .
      '\x{2F4B}\x{2F4C}\x{2F4D}\x{2F4E}\x{2F4F}\x{2F50}\x{2F51}' .
      '\x{2F52}\x{2F53}\x{2F54}\x{2F55}\x{2F56}\x{2F57}\x{2F58}' .
      '\x{2F59}\x{2F5A}\x{2F5B}\x{2F5C}\x{2F5D}\x{2F5E}\x{2F5F}' .
      '\x{2F60}\x{2F61}\x{2F62}\x{2F63}\x{2F64}\x{2F65}\x{2F66}' .
      '\x{2F67}\x{2F68}\x{2F69}\x{2F6A}\x{2F6B}\x{2F6C}\x{2F6D}' .
      '\x{2F6E}\x{2F6F}\x{2F70}\x{2F71}\x{2F72}\x{2F73}\x{2F74}' .
      '\x{2F75}\x{2F76}\x{2F77}\x{2F78}\x{2F79}\x{2F7A}\x{2F7B}' .
      '\x{2F7C}\x{2F7D}\x{2F7E}\x{2F7F}\x{2F80}\x{2F81}\x{2F82}' .
      '\x{2F83}\x{2F84}\x{2F85}\x{2F86}\x{2F87}\x{2F88}\x{2F89}' .
      '\x{2F8A}\x{2F8B}\x{2F8C}\x{2F8D}\x{2F8E}\x{2F8F}\x{2F90}' .
      '\x{2F91}\x{2F92}\x{2F93}\x{2F94}\x{2F95}\x{2F96}\x{2F97}' .
      '\x{2F98}\x{2F99}\x{2F9A}\x{2F9B}\x{2F9C}\x{2F9D}\x{2F9E}' .
      '\x{2F9F}\x{2FA0}\x{2FA1}\x{2FA2}\x{2FA3}\x{2FA4}\x{2FA5}' .
      '\x{2FA6}\x{2FA7}\x{2FA8}\x{2FA9}\x{2FAA}\x{2FAB}\x{2FAC}' .
      '\x{2FAD}\x{2FAE}\x{2FAF}\x{2FB0}\x{2FB1}\x{2FB2}\x{2FB3}' .
      '\x{2FB4}\x{2FB5}\x{2FB6}\x{2FB7}\x{2FB8}\x{2FB9}\x{2FBA}' .
      '\x{2FBB}\x{2FBC}\x{2FBD}\x{2FBE}\x{2FBF}\x{2FC0}\x{2FC1}' .
      '\x{2FC2}\x{2FC3}\x{2FC4}\x{2FC5}\x{2FC6}\x{2FC7}\x{2FC8}' .
      '\x{2FC9}\x{2FCA}\x{2FCB}\x{2FCC}\x{2FCD}\x{2FCE}\x{2FCF}' .
      '\x{2FD0}\x{2FD1}\x{2FD2}\x{2FD3}\x{2FD4}\x{2FD5}\x{2FF0}' .
      '\x{2FF1}\x{2FF2}\x{2FF3}\x{2FF4}\x{2FF5}\x{2FF6}\x{2FF7}' .
      '\x{2FF8}\x{2FF9}\x{2FFA}\x{2FFB}\x{3004}\x{3012}\x{3013}' .
      '\x{3020}\x{3036}\x{3037}\x{303E}\x{303F}\x{3190}\x{3191}' .
      '\x{3196}\x{3197}\x{3198}\x{3199}\x{319A}\x{319B}\x{319C}' .
      '\x{319D}\x{319E}\x{319F}\x{31C0}\x{31C1}\x{31C2}\x{31C3}' .
      '\x{31C4}\x{31C5}\x{31C6}\x{31C7}\x{31C8}\x{31C9}\x{31CA}' .
      '\x{31CB}\x{31CC}\x{31CD}\x{31CE}\x{31CF}\x{31D0}\x{31D1}' .
      '\x{31D2}\x{31D3}\x{31D4}\x{31D5}\x{31D6}\x{31D7}\x{31D8}' .
      '\x{31D9}\x{31DA}\x{31DB}\x{31DC}\x{31DD}\x{31DE}\x{31DF}' .
      '\x{31E0}\x{31E1}\x{31E2}\x{31E3}\x{3200}\x{3201}\x{3202}' .
      '\x{3203}\x{3204}\x{3205}\x{3206}\x{3207}\x{3208}\x{3209}' .
      '\x{320A}\x{320B}\x{320C}\x{320D}\x{320E}\x{320F}\x{3210}' .
      '\x{3211}\x{3212}\x{3213}\x{3214}\x{3215}\x{3216}\x{3217}' .
      '\x{3218}\x{3219}\x{321A}\x{321B}\x{321C}\x{321D}\x{321E}' .
      '\x{322A}\x{322B}\x{322C}\x{322D}\x{322E}\x{322F}\x{3230}' .
      '\x{3231}\x{3232}\x{3233}\x{3234}\x{3235}\x{3236}\x{3237}' .
      '\x{3238}\x{3239}\x{323A}\x{323B}\x{323C}\x{323D}\x{323E}' .
      '\x{323F}\x{3240}\x{3241}\x{3242}\x{3243}\x{3244}\x{3245}' .
      '\x{3246}\x{3247}\x{3250}\x{3260}\x{3261}\x{3262}\x{3263}' .
      '\x{3264}\x{3265}\x{3266}\x{3267}\x{3268}\x{3269}\x{326A}' .
      '\x{326B}\x{326C}\x{326D}\x{326E}\x{326F}\x{3270}\x{3271}' .
      '\x{3272}\x{3273}\x{3274}\x{3275}\x{3276}\x{3277}\x{3278}' .
      '\x{3279}\x{327A}\x{327B}\x{327C}\x{327D}\x{327E}\x{327F}' .
      '\x{328A}\x{328B}\x{328C}\x{328D}\x{328E}\x{328F}\x{3290}' .
      '\x{3291}\x{3292}\x{3293}\x{3294}\x{3295}\x{3296}\x{3297}' .
      '\x{3298}\x{3299}\x{329A}\x{329B}\x{329C}\x{329D}\x{329E}' .
      '\x{329F}\x{32A0}\x{32A1}\x{32A2}\x{32A3}\x{32A4}\x{32A5}' .
      '\x{32A6}\x{32A7}\x{32A8}\x{32A9}\x{32AA}\x{32AB}\x{32AC}' .
      '\x{32AD}\x{32AE}\x{32AF}\x{32B0}\x{32C0}\x{32C1}\x{32C2}' .
      '\x{32C3}\x{32C4}\x{32C5}\x{32C6}\x{32C7}\x{32C8}\x{32C9}' .
      '\x{32CA}\x{32CB}\x{32CC}\x{32CD}\x{32CE}\x{32CF}\x{32D0}' .
      '\x{32D1}\x{32D2}\x{32D3}\x{32D4}\x{32D5}\x{32D6}\x{32D7}' .
      '\x{32D8}\x{32D9}\x{32DA}\x{32DB}\x{32DC}\x{32DD}\x{32DE}' .
      '\x{32DF}\x{32E0}\x{32E1}\x{32E2}\x{32E3}\x{32E4}\x{32E5}' .
      '\x{32E6}\x{32E7}\x{32E8}\x{32E9}\x{32EA}\x{32EB}\x{32EC}' .
      '\x{32ED}\x{32EE}\x{32EF}\x{32F0}\x{32F1}\x{32F2}\x{32F3}' .
      '\x{32F4}\x{32F5}\x{32F6}\x{32F7}\x{32F8}\x{32F9}\x{32FA}' .
      '\x{32FB}\x{32FC}\x{32FD}\x{32FE}\x{3300}\x{3301}\x{3302}' .
      '\x{3303}\x{3304}\x{3305}\x{3306}\x{3307}\x{3308}\x{3309}' .
      '\x{330A}\x{330B}\x{330C}\x{330D}\x{330E}\x{330F}\x{3310}' .
      '\x{3311}\x{3312}\x{3313}\x{3314}\x{3315}\x{3316}\x{3317}' .
      '\x{3318}\x{3319}\x{331A}\x{331B}\x{331C}\x{331D}\x{331E}' .
      '\x{331F}\x{3320}\x{3321}\x{3322}\x{3323}\x{3324}\x{3325}' .
      '\x{3326}\x{3327}\x{3328}\x{3329}\x{332A}\x{332B}\x{332C}' .
      '\x{332D}\x{332E}\x{332F}\x{3330}\x{3331}\x{3332}\x{3333}' .
      '\x{3334}\x{3335}\x{3336}\x{3337}\x{3338}\x{3339}\x{333A}' .
      '\x{333B}\x{333C}\x{333D}\x{333E}\x{333F}\x{3340}\x{3341}' .
      '\x{3342}\x{3343}\x{3344}\x{3345}\x{3346}\x{3347}\x{3348}' .
      '\x{3349}\x{334A}\x{334B}\x{334C}\x{334D}\x{334E}\x{334F}' .
      '\x{3350}\x{3351}\x{3352}\x{3353}\x{3354}\x{3355}\x{3356}' .
      '\x{3357}\x{3358}\x{3359}\x{335A}\x{335B}\x{335C}\x{335D}' .
      '\x{335E}\x{335F}\x{3360}\x{3361}\x{3362}\x{3363}\x{3364}' .
      '\x{3365}\x{3366}\x{3367}\x{3368}\x{3369}\x{336A}\x{336B}' .
      '\x{336C}\x{336D}\x{336E}\x{336F}\x{3370}\x{3371}\x{3372}' .
      '\x{3373}\x{3374}\x{3375}\x{3376}\x{3377}\x{3378}\x{3379}' .
      '\x{337A}\x{337B}\x{337C}\x{337D}\x{337E}\x{337F}\x{3380}' .
      '\x{3381}\x{3382}\x{3383}\x{3384}\x{3385}\x{3386}\x{3387}' .
      '\x{3388}\x{3389}\x{338A}\x{338B}\x{338C}\x{338D}\x{338E}' .
      '\x{338F}\x{3390}\x{3391}\x{3392}\x{3393}\x{3394}\x{3395}' .
      '\x{3396}\x{3397}\x{3398}\x{3399}\x{339A}\x{339B}\x{339C}' .
      '\x{339D}\x{339E}\x{339F}\x{33A0}\x{33A1}\x{33A2}\x{33A3}' .
      '\x{33A4}\x{33A5}\x{33A6}\x{33A7}\x{33A8}\x{33A9}\x{33AA}' .
      '\x{33AB}\x{33AC}\x{33AD}\x{33AE}\x{33AF}\x{33B0}\x{33B1}' .
      '\x{33B2}\x{33B3}\x{33B4}\x{33B5}\x{33B6}\x{33B7}\x{33B8}' .
      '\x{33B9}\x{33BA}\x{33BB}\x{33BC}\x{33BD}\x{33BE}\x{33BF}' .
      '\x{33C0}\x{33C1}\x{33C2}\x{33C3}\x{33C4}\x{33C5}\x{33C6}' .
      '\x{33C7}\x{33C8}\x{33C9}\x{33CA}\x{33CB}\x{33CC}\x{33CD}' .
      '\x{33CE}\x{33CF}\x{33D0}\x{33D1}\x{33D2}\x{33D3}\x{33D4}' .
      '\x{33D5}\x{33D6}\x{33D7}\x{33D8}\x{33D9}\x{33DA}\x{33DB}' .
      '\x{33DC}\x{33DD}\x{33DE}\x{33DF}\x{33E0}\x{33E1}\x{33E2}' .
      '\x{33E3}\x{33E4}\x{33E5}\x{33E6}\x{33E7}\x{33E8}\x{33E9}' .
      '\x{33EA}\x{33EB}\x{33EC}\x{33ED}\x{33EE}\x{33EF}\x{33F0}' .
      '\x{33F1}\x{33F2}\x{33F3}\x{33F4}\x{33F5}\x{33F6}\x{33F7}' .
      '\x{33F8}\x{33F9}\x{33FA}\x{33FB}\x{33FC}\x{33FD}\x{33FE}' .
      '\x{33FF}\x{4DC0}\x{4DC1}\x{4DC2}\x{4DC3}\x{4DC4}\x{4DC5}' .
      '\x{4DC6}\x{4DC7}\x{4DC8}\x{4DC9}\x{4DCA}\x{4DCB}\x{4DCC}' .
      '\x{4DCD}\x{4DCE}\x{4DCF}\x{4DD0}\x{4DD1}\x{4DD2}\x{4DD3}' .
      '\x{4DD4}\x{4DD5}\x{4DD6}\x{4DD7}\x{4DD8}\x{4DD9}\x{4DDA}' .
      '\x{4DDB}\x{4DDC}\x{4DDD}\x{4DDE}\x{4DDF}\x{4DE0}\x{4DE1}' .
      '\x{4DE2}\x{4DE3}\x{4DE4}\x{4DE5}\x{4DE6}\x{4DE7}\x{4DE8}' .
      '\x{4DE9}\x{4DEA}\x{4DEB}\x{4DEC}\x{4DED}\x{4DEE}\x{4DEF}' .
      '\x{4DF0}\x{4DF1}\x{4DF2}\x{4DF3}\x{4DF4}\x{4DF5}\x{4DF6}' .
      '\x{4DF7}\x{4DF8}\x{4DF9}\x{4DFA}\x{4DFB}\x{4DFC}\x{4DFD}' .
      '\x{4DFE}\x{4DFF}\x{A490}\x{A491}\x{A492}\x{A493}\x{A494}' .
      '\x{A495}\x{A496}\x{A497}\x{A498}\x{A499}\x{A49A}\x{A49B}' .
      '\x{A49C}\x{A49D}\x{A49E}\x{A49F}\x{A4A0}\x{A4A1}\x{A4A2}' .
      '\x{A4A3}\x{A4A4}\x{A4A5}\x{A4A6}\x{A4A7}\x{A4A8}\x{A4A9}' .
      '\x{A4AA}\x{A4AB}\x{A4AC}\x{A4AD}\x{A4AE}\x{A4AF}\x{A4B0}' .
      '\x{A4B1}\x{A4B2}\x{A4B3}\x{A4B4}\x{A4B5}\x{A4B6}\x{A4B7}' .
      '\x{A4B8}\x{A4B9}\x{A4BA}\x{A4BB}\x{A4BC}\x{A4BD}\x{A4BE}' .
      '\x{A4BF}\x{A4C0}\x{A4C1}\x{A4C2}\x{A4C3}\x{A4C4}\x{A4C5}' .
      '\x{A4C6}\x{A828}\x{A829}\x{A82A}\x{A82B}\x{A836}\x{A837}' .
      '\x{A839}\x{AA77}\x{AA78}\x{AA79}\x{FDFD}\x{FFE4}\x{FFE8}' .
      '\x{FFED}\x{FFEE}\x{FFFC}\x{FFFD}\x{10137}\x{10138}\x{10139}' .
      '\x{1013A}\x{1013B}\x{1013C}\x{1013D}\x{1013E}\x{1013F}\x{10179}' .
      '\x{1017A}\x{1017B}\x{1017C}\x{1017D}\x{1017E}\x{1017F}\x{10180}' .
      '\x{10181}\x{10182}\x{10183}\x{10184}\x{10185}\x{10186}\x{10187}' .
      '\x{10188}\x{10189}\x{10190}\x{10191}\x{10192}\x{10193}\x{10194}' .
      '\x{10195}\x{10196}\x{10197}\x{10198}\x{10199}\x{1019A}\x{1019B}' .
      '\x{101D0}\x{101D1}\x{101D2}\x{101D3}\x{101D4}\x{101D5}\x{101D6}' .
      '\x{101D7}\x{101D8}\x{101D9}\x{101DA}\x{101DB}\x{101DC}\x{101DD}' .
      '\x{101DE}\x{101DF}\x{101E0}\x{101E1}\x{101E2}\x{101E3}\x{101E4}' .
      '\x{101E5}\x{101E6}\x{101E7}\x{101E8}\x{101E9}\x{101EA}\x{101EB}' .
      '\x{101EC}\x{101ED}\x{101EE}\x{101EF}\x{101F0}\x{101F1}\x{101F2}' .
      '\x{101F3}\x{101F4}\x{101F5}\x{101F6}\x{101F7}\x{101F8}\x{101F9}' .
      '\x{101FA}\x{101FB}\x{101FC}\x{1D000}\x{1D001}\x{1D002}\x{1D003}' .
      '\x{1D004}\x{1D005}\x{1D006}\x{1D007}\x{1D008}\x{1D009}\x{1D00A}' .
      '\x{1D00B}\x{1D00C}\x{1D00D}\x{1D00E}\x{1D00F}\x{1D010}\x{1D011}' .
      '\x{1D012}\x{1D013}\x{1D014}\x{1D015}\x{1D016}\x{1D017}\x{1D018}' .
      '\x{1D019}\x{1D01A}\x{1D01B}\x{1D01C}\x{1D01D}\x{1D01E}\x{1D01F}' .
      '\x{1D020}\x{1D021}\x{1D022}\x{1D023}\x{1D024}\x{1D025}\x{1D026}' .
      '\x{1D027}\x{1D028}\x{1D029}\x{1D02A}\x{1D02B}\x{1D02C}\x{1D02D}' .
      '\x{1D02E}\x{1D02F}\x{1D030}\x{1D031}\x{1D032}\x{1D033}\x{1D034}' .
      '\x{1D035}\x{1D036}\x{1D037}\x{1D038}\x{1D039}\x{1D03A}\x{1D03B}' .
      '\x{1D03C}\x{1D03D}\x{1D03E}\x{1D03F}\x{1D040}\x{1D041}\x{1D042}' .
      '\x{1D043}\x{1D044}\x{1D045}\x{1D046}\x{1D047}\x{1D048}\x{1D049}' .
      '\x{1D04A}\x{1D04B}\x{1D04C}\x{1D04D}\x{1D04E}\x{1D04F}\x{1D050}' .
      '\x{1D051}\x{1D052}\x{1D053}\x{1D054}\x{1D055}\x{1D056}\x{1D057}' .
      '\x{1D058}\x{1D059}\x{1D05A}\x{1D05B}\x{1D05C}\x{1D05D}\x{1D05E}' .
      '\x{1D05F}\x{1D060}\x{1D061}\x{1D062}\x{1D063}\x{1D064}\x{1D065}' .
      '\x{1D066}\x{1D067}\x{1D068}\x{1D069}\x{1D06A}\x{1D06B}\x{1D06C}' .
      '\x{1D06D}\x{1D06E}\x{1D06F}\x{1D070}\x{1D071}\x{1D072}\x{1D073}' .
      '\x{1D074}\x{1D075}\x{1D076}\x{1D077}\x{1D078}\x{1D079}\x{1D07A}' .
      '\x{1D07B}\x{1D07C}\x{1D07D}\x{1D07E}\x{1D07F}\x{1D080}\x{1D081}' .
      '\x{1D082}\x{1D083}\x{1D084}\x{1D085}\x{1D086}\x{1D087}\x{1D088}' .
      '\x{1D089}\x{1D08A}\x{1D08B}\x{1D08C}\x{1D08D}\x{1D08E}\x{1D08F}' .
      '\x{1D090}\x{1D091}\x{1D092}\x{1D093}\x{1D094}\x{1D095}\x{1D096}' .
      '\x{1D097}\x{1D098}\x{1D099}\x{1D09A}\x{1D09B}\x{1D09C}\x{1D09D}' .
      '\x{1D09E}\x{1D09F}\x{1D0A0}\x{1D0A1}\x{1D0A2}\x{1D0A3}\x{1D0A4}' .
      '\x{1D0A5}\x{1D0A6}\x{1D0A7}\x{1D0A8}\x{1D0A9}\x{1D0AA}\x{1D0AB}' .
      '\x{1D0AC}\x{1D0AD}\x{1D0AE}\x{1D0AF}\x{1D0B0}\x{1D0B1}\x{1D0B2}' .
      '\x{1D0B3}\x{1D0B4}\x{1D0B5}\x{1D0B6}\x{1D0B7}\x{1D0B8}\x{1D0B9}' .
      '\x{1D0BA}\x{1D0BB}\x{1D0BC}\x{1D0BD}\x{1D0BE}\x{1D0BF}\x{1D0C0}' .
      '\x{1D0C1}\x{1D0C2}\x{1D0C3}\x{1D0C4}\x{1D0C5}\x{1D0C6}\x{1D0C7}' .
      '\x{1D0C8}\x{1D0C9}\x{1D0CA}\x{1D0CB}\x{1D0CC}\x{1D0CD}\x{1D0CE}' .
      '\x{1D0CF}\x{1D0D0}\x{1D0D1}\x{1D0D2}\x{1D0D3}\x{1D0D4}\x{1D0D5}' .
      '\x{1D0D6}\x{1D0D7}\x{1D0D8}\x{1D0D9}\x{1D0DA}\x{1D0DB}\x{1D0DC}' .
      '\x{1D0DD}\x{1D0DE}\x{1D0DF}\x{1D0E0}\x{1D0E1}\x{1D0E2}\x{1D0E3}' .
      '\x{1D0E4}\x{1D0E5}\x{1D0E6}\x{1D0E7}\x{1D0E8}\x{1D0E9}\x{1D0EA}' .
      '\x{1D0EB}\x{1D0EC}\x{1D0ED}\x{1D0EE}\x{1D0EF}\x{1D0F0}\x{1D0F1}' .
      '\x{1D0F2}\x{1D0F3}\x{1D0F4}\x{1D0F5}\x{1D100}\x{1D101}\x{1D102}' .
      '\x{1D103}\x{1D104}\x{1D105}\x{1D106}\x{1D107}\x{1D108}\x{1D109}' .
      '\x{1D10A}\x{1D10B}\x{1D10C}\x{1D10D}\x{1D10E}\x{1D10F}\x{1D110}' .
      '\x{1D111}\x{1D112}\x{1D113}\x{1D114}\x{1D115}\x{1D116}\x{1D117}' .
      '\x{1D118}\x{1D119}\x{1D11A}\x{1D11B}\x{1D11C}\x{1D11D}\x{1D11E}' .
      '\x{1D11F}\x{1D120}\x{1D121}\x{1D122}\x{1D123}\x{1D124}\x{1D125}' .
      '\x{1D126}\x{1D129}\x{1D12A}\x{1D12B}\x{1D12C}\x{1D12D}\x{1D12E}' .
      '\x{1D12F}\x{1D130}\x{1D131}\x{1D132}\x{1D133}\x{1D134}\x{1D135}' .
      '\x{1D136}\x{1D137}\x{1D138}\x{1D139}\x{1D13A}\x{1D13B}\x{1D13C}' .
      '\x{1D13D}\x{1D13E}\x{1D13F}\x{1D140}\x{1D141}\x{1D142}\x{1D143}' .
      '\x{1D144}\x{1D145}\x{1D146}\x{1D147}\x{1D148}\x{1D149}\x{1D14A}' .
      '\x{1D14B}\x{1D14C}\x{1D14D}\x{1D14E}\x{1D14F}\x{1D150}\x{1D151}' .
      '\x{1D152}\x{1D153}\x{1D154}\x{1D155}\x{1D156}\x{1D157}\x{1D158}' .
      '\x{1D159}\x{1D15A}\x{1D15B}\x{1D15C}\x{1D15D}\x{1D15E}\x{1D15F}' .
      '\x{1D160}\x{1D161}\x{1D162}\x{1D163}\x{1D164}\x{1D16A}\x{1D16B}' .
      '\x{1D16C}\x{1D183}\x{1D184}\x{1D18C}\x{1D18D}\x{1D18E}\x{1D18F}' .
      '\x{1D190}\x{1D191}\x{1D192}\x{1D193}\x{1D194}\x{1D195}\x{1D196}' .
      '\x{1D197}\x{1D198}\x{1D199}\x{1D19A}\x{1D19B}\x{1D19C}\x{1D19D}' .
      '\x{1D19E}\x{1D19F}\x{1D1A0}\x{1D1A1}\x{1D1A2}\x{1D1A3}\x{1D1A4}' .
      '\x{1D1A5}\x{1D1A6}\x{1D1A7}\x{1D1A8}\x{1D1A9}\x{1D1AE}\x{1D1AF}' .
      '\x{1D1B0}\x{1D1B1}\x{1D1B2}\x{1D1B3}\x{1D1B4}\x{1D1B5}\x{1D1B6}' .
      '\x{1D1B7}\x{1D1B8}\x{1D1B9}\x{1D1BA}\x{1D1BB}\x{1D1BC}\x{1D1BD}' .
      '\x{1D1BE}\x{1D1BF}\x{1D1C0}\x{1D1C1}\x{1D1C2}\x{1D1C3}\x{1D1C4}' .
      '\x{1D1C5}\x{1D1C6}\x{1D1C7}\x{1D1C8}\x{1D1C9}\x{1D1CA}\x{1D1CB}' .
      '\x{1D1CC}\x{1D1CD}\x{1D1CE}\x{1D1CF}\x{1D1D0}\x{1D1D1}\x{1D1D2}' .
      '\x{1D1D3}\x{1D1D4}\x{1D1D5}\x{1D1D6}\x{1D1D7}\x{1D1D8}\x{1D1D9}' .
      '\x{1D1DA}\x{1D1DB}\x{1D1DC}\x{1D1DD}\x{1D200}\x{1D201}\x{1D202}' .
      '\x{1D203}\x{1D204}\x{1D205}\x{1D206}\x{1D207}\x{1D208}\x{1D209}' .
      '\x{1D20A}\x{1D20B}\x{1D20C}\x{1D20D}\x{1D20E}\x{1D20F}\x{1D210}' .
      '\x{1D211}\x{1D212}\x{1D213}\x{1D214}\x{1D215}\x{1D216}\x{1D217}' .
      '\x{1D218}\x{1D219}\x{1D21A}\x{1D21B}\x{1D21C}\x{1D21D}\x{1D21E}' .
      '\x{1D21F}\x{1D220}\x{1D221}\x{1D222}\x{1D223}\x{1D224}\x{1D225}' .
      '\x{1D226}\x{1D227}\x{1D228}\x{1D229}\x{1D22A}\x{1D22B}\x{1D22C}' .
      '\x{1D22D}\x{1D22E}\x{1D22F}\x{1D230}\x{1D231}\x{1D232}\x{1D233}' .
      '\x{1D234}\x{1D235}\x{1D236}\x{1D237}\x{1D238}\x{1D239}\x{1D23A}' .
      '\x{1D23B}\x{1D23C}\x{1D23D}\x{1D23E}\x{1D23F}\x{1D240}\x{1D241}' .
      '\x{1D245}\x{1D300}\x{1D301}\x{1D302}\x{1D303}\x{1D304}\x{1D305}' .
      '\x{1D306}\x{1D307}\x{1D308}\x{1D309}\x{1D30A}\x{1D30B}\x{1D30C}' .
      '\x{1D30D}\x{1D30E}\x{1D30F}\x{1D310}\x{1D311}\x{1D312}\x{1D313}' .
      '\x{1D314}\x{1D315}\x{1D316}\x{1D317}\x{1D318}\x{1D319}\x{1D31A}' .
      '\x{1D31B}\x{1D31C}\x{1D31D}\x{1D31E}\x{1D31F}\x{1D320}\x{1D321}' .
      '\x{1D322}\x{1D323}\x{1D324}\x{1D325}\x{1D326}\x{1D327}\x{1D328}' .
      '\x{1D329}\x{1D32A}\x{1D32B}\x{1D32C}\x{1D32D}\x{1D32E}\x{1D32F}' .
      '\x{1D330}\x{1D331}\x{1D332}\x{1D333}\x{1D334}\x{1D335}\x{1D336}' .
      '\x{1D337}\x{1D338}\x{1D339}\x{1D33A}\x{1D33B}\x{1D33C}\x{1D33D}' .
      '\x{1D33E}\x{1D33F}\x{1D340}\x{1D341}\x{1D342}\x{1D343}\x{1D344}' .
      '\x{1D345}\x{1D346}\x{1D347}\x{1D348}\x{1D349}\x{1D34A}\x{1D34B}' .
      '\x{1D34C}\x{1D34D}\x{1D34E}\x{1D34F}\x{1D350}\x{1D351}\x{1D352}' .
      '\x{1D353}\x{1D354}\x{1D355}\x{1D356}\x{1F000}\x{1F001}\x{1F002}' .
      '\x{1F003}\x{1F004}\x{1F005}\x{1F006}\x{1F007}\x{1F008}\x{1F009}' .
      '\x{1F00A}\x{1F00B}\x{1F00C}\x{1F00D}\x{1F00E}\x{1F00F}\x{1F010}' .
      '\x{1F011}\x{1F012}\x{1F013}\x{1F014}\x{1F015}\x{1F016}\x{1F017}' .
      '\x{1F018}\x{1F019}\x{1F01A}\x{1F01B}\x{1F01C}\x{1F01D}\x{1F01E}' .
      '\x{1F01F}\x{1F020}\x{1F021}\x{1F022}\x{1F023}\x{1F024}\x{1F025}' .
      '\x{1F026}\x{1F027}\x{1F028}\x{1F029}\x{1F02A}\x{1F02B}\x{1F030}' .
      '\x{1F031}\x{1F032}\x{1F033}\x{1F034}\x{1F035}\x{1F036}\x{1F037}' .
      '\x{1F038}\x{1F039}\x{1F03A}\x{1F03B}\x{1F03C}\x{1F03D}\x{1F03E}' .
      '\x{1F03F}\x{1F040}\x{1F041}\x{1F042}\x{1F043}\x{1F044}\x{1F045}' .
      '\x{1F046}\x{1F047}\x{1F048}\x{1F049}\x{1F04A}\x{1F04B}\x{1F04C}' .
      '\x{1F04D}\x{1F04E}\x{1F04F}\x{1F050}\x{1F051}\x{1F052}\x{1F053}' .
      '\x{1F054}\x{1F055}\x{1F056}\x{1F057}\x{1F058}\x{1F059}\x{1F05A}' .
      '\x{1F05B}\x{1F05C}\x{1F05D}\x{1F05E}\x{1F05F}\x{1F060}\x{1F061}' .
      '\x{1F062}\x{1F063}\x{1F064}\x{1F065}\x{1F066}\x{1F067}\x{1F068}' .
      '\x{1F069}\x{1F06A}\x{1F06B}\x{1F06C}\x{1F06D}\x{1F06E}\x{1F06F}' .
      '\x{1F070}\x{1F071}\x{1F072}\x{1F073}\x{1F074}\x{1F075}\x{1F076}' .
      '\x{1F077}\x{1F078}\x{1F079}\x{1F07A}\x{1F07B}\x{1F07C}\x{1F07D}' .
      '\x{1F07E}\x{1F07F}\x{1F080}\x{1F081}\x{1F082}\x{1F083}\x{1F084}' .
      '\x{1F085}\x{1F086}\x{1F087}\x{1F088}\x{1F089}\x{1F08A}\x{1F08B}' .
      '\x{1F08C}\x{1F08D}\x{1F08E}\x{1F08F}\x{1F090}\x{1F091}\x{1F092}' .
      '\x{1F093}\x{1F0A0}\x{1F0A1}\x{1F0A2}\x{1F0A3}\x{1F0A4}\x{1F0A5}' .
      '\x{1F0A6}\x{1F0A7}\x{1F0A8}\x{1F0A9}\x{1F0AA}\x{1F0AB}\x{1F0AC}' .
      '\x{1F0AD}\x{1F0AE}\x{1F0B1}\x{1F0B2}\x{1F0B3}\x{1F0B4}\x{1F0B5}' .
      '\x{1F0B6}\x{1F0B7}\x{1F0B8}\x{1F0B9}\x{1F0BA}\x{1F0BB}\x{1F0BC}' .
      '\x{1F0BD}\x{1F0BE}\x{1F0C1}\x{1F0C2}\x{1F0C3}\x{1F0C4}\x{1F0C5}' .
      '\x{1F0C6}\x{1F0C7}\x{1F0C8}\x{1F0C9}\x{1F0CA}\x{1F0CB}\x{1F0CC}' .
      '\x{1F0CD}\x{1F0CE}\x{1F0CF}\x{1F0D1}\x{1F0D2}\x{1F0D3}\x{1F0D4}' .
      '\x{1F0D5}\x{1F0D6}\x{1F0D7}\x{1F0D8}\x{1F0D9}\x{1F0DA}\x{1F0DB}' .
      '\x{1F0DC}\x{1F0DD}\x{1F0DE}\x{1F0DF}\x{1F110}\x{1F111}\x{1F112}' .
      '\x{1F113}\x{1F114}\x{1F115}\x{1F116}\x{1F117}\x{1F118}\x{1F119}' .
      '\x{1F11A}\x{1F11B}\x{1F11C}\x{1F11D}\x{1F11E}\x{1F11F}\x{1F120}' .
      '\x{1F121}\x{1F122}\x{1F123}\x{1F124}\x{1F125}\x{1F126}\x{1F127}' .
      '\x{1F128}\x{1F129}\x{1F12A}\x{1F12B}\x{1F12C}\x{1F12D}\x{1F12E}' .
      '\x{1F130}\x{1F131}\x{1F132}\x{1F133}\x{1F134}\x{1F135}\x{1F136}' .
      '\x{1F137}\x{1F138}\x{1F139}\x{1F13A}\x{1F13B}\x{1F13C}\x{1F13D}' .
      '\x{1F13E}\x{1F13F}\x{1F140}\x{1F141}\x{1F142}\x{1F143}\x{1F144}' .
      '\x{1F145}\x{1F146}\x{1F147}\x{1F148}\x{1F149}\x{1F14A}\x{1F14B}' .
      '\x{1F14C}\x{1F14D}\x{1F14E}\x{1F14F}\x{1F150}\x{1F151}\x{1F152}' .
      '\x{1F153}\x{1F154}\x{1F155}\x{1F156}\x{1F157}\x{1F158}\x{1F159}' .
      '\x{1F15A}\x{1F15B}\x{1F15C}\x{1F15D}\x{1F15E}\x{1F15F}\x{1F160}' .
      '\x{1F161}\x{1F162}\x{1F163}\x{1F164}\x{1F165}\x{1F166}\x{1F167}' .
      '\x{1F168}\x{1F169}\x{1F16A}\x{1F16B}\x{1F170}\x{1F171}\x{1F172}' .
      '\x{1F173}\x{1F174}\x{1F175}\x{1F176}\x{1F177}\x{1F178}\x{1F179}' .
      '\x{1F17A}\x{1F17B}\x{1F17C}\x{1F17D}\x{1F17E}\x{1F17F}\x{1F180}' .
      '\x{1F181}\x{1F182}\x{1F183}\x{1F184}\x{1F185}\x{1F186}\x{1F187}' .
      '\x{1F188}\x{1F189}\x{1F18A}\x{1F18B}\x{1F18C}\x{1F18D}\x{1F18E}' .
      '\x{1F18F}\x{1F190}\x{1F191}\x{1F192}\x{1F193}\x{1F194}\x{1F195}' .
      '\x{1F196}\x{1F197}\x{1F198}\x{1F199}\x{1F19A}\x{1F1E6}\x{1F1E7}' .
      '\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}' .
      '\x{1F1EF}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F4}\x{1F1F5}' .
      '\x{1F1F6}\x{1F1F7}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FC}' .
      '\x{1F1FD}\x{1F1FE}\x{1F1FF}\x{1F200}\x{1F201}\x{1F202}\x{1F210}' .
      '\x{1F211}\x{1F212}\x{1F213}\x{1F214}\x{1F215}\x{1F216}\x{1F217}' .
      '\x{1F218}\x{1F219}\x{1F21A}\x{1F21B}\x{1F21C}\x{1F21D}\x{1F21E}' .
      '\x{1F21F}\x{1F220}\x{1F221}\x{1F222}\x{1F223}\x{1F224}\x{1F225}' .
      '\x{1F226}\x{1F227}\x{1F228}\x{1F229}\x{1F22A}\x{1F22B}\x{1F22C}' .
      '\x{1F22D}\x{1F22E}\x{1F22F}\x{1F230}\x{1F231}\x{1F232}\x{1F233}' .
      '\x{1F234}\x{1F235}\x{1F236}\x{1F237}\x{1F238}\x{1F239}\x{1F23A}' .
      '\x{1F240}\x{1F241}\x{1F242}\x{1F243}\x{1F244}\x{1F245}\x{1F246}' .
      '\x{1F247}\x{1F248}\x{1F250}\x{1F251}\x{1F300}\x{1F301}\x{1F302}' .
      '\x{1F303}\x{1F304}\x{1F305}\x{1F306}\x{1F307}\x{1F308}\x{1F309}' .
      '\x{1F30A}\x{1F30B}\x{1F30C}\x{1F30D}\x{1F30E}\x{1F30F}\x{1F310}' .
      '\x{1F311}\x{1F312}\x{1F313}\x{1F314}\x{1F315}\x{1F316}\x{1F317}' .
      '\x{1F318}\x{1F319}\x{1F31A}\x{1F31B}\x{1F31C}\x{1F31D}\x{1F31E}' .
      '\x{1F31F}\x{1F320}\x{1F330}\x{1F331}\x{1F332}\x{1F333}\x{1F334}' .
      '\x{1F335}\x{1F337}\x{1F338}\x{1F339}\x{1F33A}\x{1F33B}\x{1F33C}' .
      '\x{1F33D}\x{1F33E}\x{1F33F}\x{1F340}\x{1F341}\x{1F342}\x{1F343}' .
      '\x{1F344}\x{1F345}\x{1F346}\x{1F347}\x{1F348}\x{1F349}\x{1F34A}' .
      '\x{1F34B}\x{1F34C}\x{1F34D}\x{1F34E}\x{1F34F}\x{1F350}\x{1F351}' .
      '\x{1F352}\x{1F353}\x{1F354}\x{1F355}\x{1F356}\x{1F357}\x{1F358}' .
      '\x{1F359}\x{1F35A}\x{1F35B}\x{1F35C}\x{1F35D}\x{1F35E}\x{1F35F}' .
      '\x{1F360}\x{1F361}\x{1F362}\x{1F363}\x{1F364}\x{1F365}\x{1F366}' .
      '\x{1F367}\x{1F368}\x{1F369}\x{1F36A}\x{1F36B}\x{1F36C}\x{1F36D}' .
      '\x{1F36E}\x{1F36F}\x{1F370}\x{1F371}\x{1F372}\x{1F373}\x{1F374}' .
      '\x{1F375}\x{1F376}\x{1F377}\x{1F378}\x{1F379}\x{1F37A}\x{1F37B}' .
      '\x{1F37C}\x{1F380}\x{1F381}\x{1F382}\x{1F383}\x{1F384}\x{1F385}' .
      '\x{1F386}\x{1F387}\x{1F388}\x{1F389}\x{1F38A}\x{1F38B}\x{1F38C}' .
      '\x{1F38D}\x{1F38E}\x{1F38F}\x{1F390}\x{1F391}\x{1F392}\x{1F393}' .
      '\x{1F3A0}\x{1F3A1}\x{1F3A2}\x{1F3A3}\x{1F3A4}\x{1F3A5}\x{1F3A6}' .
      '\x{1F3A7}\x{1F3A8}\x{1F3A9}\x{1F3AA}\x{1F3AB}\x{1F3AC}\x{1F3AD}' .
      '\x{1F3AE}\x{1F3AF}\x{1F3B0}\x{1F3B1}\x{1F3B2}\x{1F3B3}\x{1F3B4}' .
      '\x{1F3B5}\x{1F3B6}\x{1F3B7}\x{1F3B8}\x{1F3B9}\x{1F3BA}\x{1F3BB}' .
      '\x{1F3BC}\x{1F3BD}\x{1F3BE}\x{1F3BF}\x{1F3C0}\x{1F3C1}\x{1F3C2}' .
      '\x{1F3C3}\x{1F3C4}\x{1F3C6}\x{1F3C7}\x{1F3C8}\x{1F3C9}\x{1F3CA}' .
      '\x{1F3E0}\x{1F3E1}\x{1F3E2}\x{1F3E3}\x{1F3E4}\x{1F3E5}\x{1F3E6}' .
      '\x{1F3E7}\x{1F3E8}\x{1F3E9}\x{1F3EA}\x{1F3EB}\x{1F3EC}\x{1F3ED}' .
      '\x{1F3EE}\x{1F3EF}\x{1F3F0}\x{1F400}\x{1F401}\x{1F402}\x{1F403}' .
      '\x{1F404}\x{1F405}\x{1F406}\x{1F407}\x{1F408}\x{1F409}\x{1F40A}' .
      '\x{1F40B}\x{1F40C}\x{1F40D}\x{1F40E}\x{1F40F}\x{1F410}\x{1F411}' .
      '\x{1F412}\x{1F413}\x{1F414}\x{1F415}\x{1F416}\x{1F417}\x{1F418}' .
      '\x{1F419}\x{1F41A}\x{1F41B}\x{1F41C}\x{1F41D}\x{1F41E}\x{1F41F}' .
      '\x{1F420}\x{1F421}\x{1F422}\x{1F423}\x{1F424}\x{1F425}\x{1F426}' .
      '\x{1F427}\x{1F428}\x{1F429}\x{1F42A}\x{1F42B}\x{1F42C}\x{1F42D}' .
      '\x{1F42E}\x{1F42F}\x{1F430}\x{1F431}\x{1F432}\x{1F433}\x{1F434}' .
      '\x{1F435}\x{1F436}\x{1F437}\x{1F438}\x{1F439}\x{1F43A}\x{1F43B}' .
      '\x{1F43C}\x{1F43D}\x{1F43E}\x{1F440}\x{1F442}\x{1F443}\x{1F444}' .
      '\x{1F445}\x{1F446}\x{1F447}\x{1F448}\x{1F449}\x{1F44A}\x{1F44B}' .
      '\x{1F44C}\x{1F44D}\x{1F44E}\x{1F44F}\x{1F450}\x{1F451}\x{1F452}' .
      '\x{1F453}\x{1F454}\x{1F455}\x{1F456}\x{1F457}\x{1F458}\x{1F459}' .
      '\x{1F45A}\x{1F45B}\x{1F45C}\x{1F45D}\x{1F45E}\x{1F45F}\x{1F460}' .
      '\x{1F461}\x{1F462}\x{1F463}\x{1F464}\x{1F465}\x{1F466}\x{1F467}' .
      '\x{1F468}\x{1F469}\x{1F46A}\x{1F46B}\x{1F46C}\x{1F46D}\x{1F46E}' .
      '\x{1F46F}\x{1F470}\x{1F471}\x{1F472}\x{1F473}\x{1F474}\x{1F475}' .
      '\x{1F476}\x{1F477}\x{1F478}\x{1F479}\x{1F47A}\x{1F47B}\x{1F47C}' .
      '\x{1F47D}\x{1F47E}\x{1F47F}\x{1F480}\x{1F481}\x{1F482}\x{1F483}' .
      '\x{1F484}\x{1F485}\x{1F486}\x{1F487}\x{1F488}\x{1F489}\x{1F48A}' .
      '\x{1F48B}\x{1F48C}\x{1F48D}\x{1F48E}\x{1F48F}\x{1F490}\x{1F491}' .
      '\x{1F492}\x{1F493}\x{1F494}\x{1F495}\x{1F496}\x{1F497}\x{1F498}' .
      '\x{1F499}\x{1F49A}\x{1F49B}\x{1F49C}\x{1F49D}\x{1F49E}\x{1F49F}' .
      '\x{1F4A0}\x{1F4A1}\x{1F4A2}\x{1F4A3}\x{1F4A4}\x{1F4A5}\x{1F4A6}' .
      '\x{1F4A7}\x{1F4A8}\x{1F4A9}\x{1F4AA}\x{1F4AB}\x{1F4AC}\x{1F4AD}' .
      '\x{1F4AE}\x{1F4AF}\x{1F4B0}\x{1F4B1}\x{1F4B2}\x{1F4B3}\x{1F4B4}' .
      '\x{1F4B5}\x{1F4B6}\x{1F4B7}\x{1F4B8}\x{1F4B9}\x{1F4BA}\x{1F4BB}' .
      '\x{1F4BC}\x{1F4BD}\x{1F4BE}\x{1F4BF}\x{1F4C0}\x{1F4C1}\x{1F4C2}' .
      '\x{1F4C3}\x{1F4C4}\x{1F4C5}\x{1F4C6}\x{1F4C7}\x{1F4C8}\x{1F4C9}' .
      '\x{1F4CA}\x{1F4CB}\x{1F4CC}\x{1F4CD}\x{1F4CE}\x{1F4CF}\x{1F4D0}' .
      '\x{1F4D1}\x{1F4D2}\x{1F4D3}\x{1F4D4}\x{1F4D5}\x{1F4D6}\x{1F4D7}' .
      '\x{1F4D8}\x{1F4D9}\x{1F4DA}\x{1F4DB}\x{1F4DC}\x{1F4DD}\x{1F4DE}' .
      '\x{1F4DF}\x{1F4E0}\x{1F4E1}\x{1F4E2}\x{1F4E3}\x{1F4E4}\x{1F4E5}' .
      '\x{1F4E6}\x{1F4E7}\x{1F4E8}\x{1F4E9}\x{1F4EA}\x{1F4EB}\x{1F4EC}' .
      '\x{1F4ED}\x{1F4EE}\x{1F4EF}\x{1F4F0}\x{1F4F1}\x{1F4F2}\x{1F4F3}' .
      '\x{1F4F4}\x{1F4F5}\x{1F4F6}\x{1F4F7}\x{1F4F9}\x{1F4FA}\x{1F4FB}' .
      '\x{1F4FC}\x{1F500}\x{1F501}\x{1F502}\x{1F503}\x{1F504}\x{1F505}' .
      '\x{1F506}\x{1F507}\x{1F508}\x{1F509}\x{1F50A}\x{1F50B}\x{1F50C}' .
      '\x{1F50D}\x{1F50E}\x{1F50F}\x{1F510}\x{1F511}\x{1F512}\x{1F513}' .
      '\x{1F514}\x{1F515}\x{1F516}\x{1F517}\x{1F518}\x{1F519}\x{1F51A}' .
      '\x{1F51B}\x{1F51C}\x{1F51D}\x{1F51E}\x{1F51F}\x{1F520}\x{1F521}' .
      '\x{1F522}\x{1F523}\x{1F524}\x{1F525}\x{1F526}\x{1F527}\x{1F528}' .
      '\x{1F529}\x{1F52A}\x{1F52B}\x{1F52C}\x{1F52D}\x{1F52E}\x{1F52F}' .
      '\x{1F530}\x{1F531}\x{1F532}\x{1F533}\x{1F534}\x{1F535}\x{1F536}' .
      '\x{1F537}\x{1F538}\x{1F539}\x{1F53A}\x{1F53B}\x{1F53C}\x{1F53D}' .
      '\x{1F540}\x{1F541}\x{1F542}\x{1F543}\x{1F550}\x{1F551}\x{1F552}' .
      '\x{1F553}\x{1F554}\x{1F555}\x{1F556}\x{1F557}\x{1F558}\x{1F559}' .
      '\x{1F55A}\x{1F55B}\x{1F55C}\x{1F55D}\x{1F55E}\x{1F55F}\x{1F560}' .
      '\x{1F561}\x{1F562}\x{1F563}\x{1F564}\x{1F565}\x{1F566}\x{1F567}' .
      '\x{1F5FB}\x{1F5FC}\x{1F5FD}\x{1F5FE}\x{1F5FF}\x{1F600}\x{1F601}' .
      '\x{1F602}\x{1F603}\x{1F604}\x{1F605}\x{1F606}\x{1F607}\x{1F608}' .
      '\x{1F609}\x{1F60A}\x{1F60B}\x{1F60C}\x{1F60D}\x{1F60E}\x{1F60F}' .
      '\x{1F610}\x{1F611}\x{1F612}\x{1F613}\x{1F614}\x{1F615}\x{1F616}' .
      '\x{1F617}\x{1F618}\x{1F619}\x{1F61A}\x{1F61B}\x{1F61C}\x{1F61D}' .
      '\x{1F61E}\x{1F61F}\x{1F620}\x{1F621}\x{1F622}\x{1F623}\x{1F624}' .
      '\x{1F625}\x{1F626}\x{1F627}\x{1F628}\x{1F629}\x{1F62A}\x{1F62B}' .
      '\x{1F62C}\x{1F62D}\x{1F62E}\x{1F62F}\x{1F630}\x{1F631}\x{1F632}' .
      '\x{1F633}\x{1F634}\x{1F635}\x{1F636}\x{1F637}\x{1F638}\x{1F639}' .
      '\x{1F63A}\x{1F63B}\x{1F63C}\x{1F63D}\x{1F63E}\x{1F63F}\x{1F640}' .
      '\x{1F645}\x{1F646}\x{1F647}\x{1F648}\x{1F649}\x{1F64A}\x{1F64B}' .
      '\x{1F64C}\x{1F64D}\x{1F64E}\x{1F64F}\x{1F680}\x{1F681}\x{1F682}' .
      '\x{1F683}\x{1F684}\x{1F685}\x{1F686}\x{1F687}\x{1F688}\x{1F689}' .
      '\x{1F68A}\x{1F68B}\x{1F68C}\x{1F68D}\x{1F68E}\x{1F68F}\x{1F690}' .
      '\x{1F691}\x{1F692}\x{1F693}\x{1F694}\x{1F695}\x{1F696}\x{1F697}' .
      '\x{1F698}\x{1F699}\x{1F69A}\x{1F69B}\x{1F69C}\x{1F69D}\x{1F69E}' .
      '\x{1F69F}\x{1F6A0}\x{1F6A1}\x{1F6A2}\x{1F6A3}\x{1F6A4}\x{1F6A5}' .
      '\x{1F6A6}\x{1F6A7}\x{1F6A8}\x{1F6A9}\x{1F6AA}\x{1F6AB}\x{1F6AC}' .
      '\x{1F6AD}\x{1F6AE}\x{1F6AF}\x{1F6B0}\x{1F6B1}\x{1F6B2}\x{1F6B3}' .
      '\x{1F6B4}\x{1F6B5}\x{1F6B6}\x{1F6B7}\x{1F6B8}\x{1F6B9}\x{1F6BA}' .
      '\x{1F6BB}\x{1F6BC}\x{1F6BD}\x{1F6BE}\x{1F6BF}\x{1F6C0}\x{1F6C1}' .
      '\x{1F6C2}\x{1F6C3}\x{1F6C4}\x{1F6C5}\x{1F700}\x{1F701}\x{1F702}' .
      '\x{1F703}\x{1F704}\x{1F705}\x{1F706}\x{1F707}\x{1F708}\x{1F709}' .
      '\x{1F70A}\x{1F70B}\x{1F70C}\x{1F70D}\x{1F70E}\x{1F70F}\x{1F710}' .
      '\x{1F711}\x{1F712}\x{1F713}\x{1F714}\x{1F715}\x{1F716}\x{1F717}' .
      '\x{1F718}\x{1F719}\x{1F71A}\x{1F71B}\x{1F71C}\x{1F71D}\x{1F71E}' .
      '\x{1F71F}\x{1F720}\x{1F721}\x{1F722}\x{1F723}\x{1F724}\x{1F725}' .
      '\x{1F726}\x{1F727}\x{1F728}\x{1F729}\x{1F72A}\x{1F72B}\x{1F72C}' .
      '\x{1F72D}\x{1F72E}\x{1F72F}\x{1F730}\x{1F731}\x{1F732}\x{1F733}' .
      '\x{1F734}\x{1F735}\x{1F736}\x{1F737}\x{1F738}\x{1F739}\x{1F73A}' .
      '\x{1F73B}\x{1F73C}\x{1F73D}\x{1F73E}\x{1F73F}\x{1F740}\x{1F741}' .
      '\x{1F742}\x{1F743}\x{1F744}\x{1F745}\x{1F746}\x{1F747}\x{1F748}' .
      '\x{1F749}\x{1F74A}\x{1F74B}\x{1F74C}\x{1F74D}\x{1F74E}\x{1F74F}' .
      '\x{1F750}\x{1F751}\x{1F752}\x{1F753}\x{1F754}\x{1F755}\x{1F756}' .
      '\x{1F757}\x{1F758}\x{1F759}\x{1F75A}\x{1F75B}\x{1F75C}\x{1F75D}' .
      '\x{1F75E}\x{1F75F}\x{1F760}\x{1F761}\x{1F762}\x{1F763}\x{1F764}' .
      '\x{1F765}\x{1F766}\x{1F767}\x{1F768}\x{1F769}\x{1F76A}\x{1F76B}' .
      '\x{1F76C}\x{1F76D}\x{1F76E}\x{1F76F}\x{1F770}\x{1F771}\x{1F772}' .
      '\x{1F773}';
    // phpcs:enable
    // cspell:enable
  }

}
